/*
 * AddressListPanel.java
 * 
 */

package com.sun.demo.addressbook;

import com.sun.demo.addressbook.PartListEntry;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;

/**
 *
 * @author  John O'Conner
 */
public class PartListPanel extends javax.swing.JPanel {
    private PartListEntryRenderer renderer;
    private DefaultListModel model;
    
    /** Creates new form AddressListPanel */
    public PartListPanel() {
        renderer = new PartListEntryRenderer();
        model = new DefaultListModel();
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        partScrollPane = new javax.swing.JScrollPane();
        partList = new javax.swing.JList();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        partScrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        partList.setModel(model);
        partList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        partList.setCellRenderer(renderer);
        partList.setName("partList");
        partScrollPane.setViewportView(partList);

        add(partScrollPane);

    }// </editor-fold>//GEN-END:initComponents
    
    public void addListEntry(PartListEntry entry) {
        model.addElement(entry);
    }
    
    public void addListEntries(List<PartListEntry> list) {
        for(PartListEntry entry: list) { 
            addListEntry(entry);
        }
    }
    
    public void clearSelection() {
        partList.clearSelection();
    }
    
    public int getSelectedIndex() {
        return partList.getSelectedIndex();
    }
    
    public int setSelectedIndex(int index) {
        assert(index >= -1);
        DefaultListModel model = (DefaultListModel)partList.getModel();
        int size = model.getSize();
        if (index < size) {
            partList.setSelectedIndex(index);
        } else {
            partList.setSelectedIndex(size-1);
            index = size -1;
        }
        return index;
    }
    
    public PartListEntry getSelectedListEntry() {
        PartListEntry entry = (PartListEntry)partList.getSelectedValue();
        return entry;
    }
    
    public int deleteSelectedEntry() {
        int selectedIndex = partList.getSelectedIndex();
        if (selectedIndex >= 0) {
            DefaultListModel model = (DefaultListModel)partList.getModel();
            model.remove(selectedIndex);
        }
        return selectedIndex;
    }
    public void addListSelectionListener(ListSelectionListener listener) {
        partList.addListSelectionListener(listener);
    }
    
    public void removeListSelectionListener(ListSelectionListener listener) {
        partList.removeListSelectionListener(listener);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList partList;
    private javax.swing.JScrollPane partScrollPane;
    // End of variables declaration//GEN-END:variables
    
}
