/*
 * PartPanel.java
 *
 */
package com.sun.demo.addressbook;

import com.sun.demo.addressbook.db.PartGroupDao;
import java.util.List;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;

/**
 *
 */
public class PartPanel extends javax.swing.JPanel {
    DefaultListModel availableGroupsModel;
    DefaultListModel assignedGroupsModel;
    int id;
    boolean isEditable;
    Part part;
    
    /** Creates new form AddressPanel */
    public PartPanel() {
        availableGroupsModel = new DefaultListModel();
        assignedGroupsModel = new DefaultListModel();
        initComponents();
        part = new Part();
    }
    
    public void addAvailableGroupEntry(GroupListEntry entry) {
        availableGroupsModel.addElement(entry);
    }
    
    public void setAvailableGroupEntries(List<GroupListEntry> list) {
        availableGroupsModel.clear();
        for(GroupListEntry entry: list) {
            addAvailableGroupEntry(entry);
        }
    }
    
    public void addAssignedGroupEntry(GroupListEntry entry) {
        assignedGroupsModel.addElement(entry);
    }
    
    public void setAssignedGroupEntries(List<GroupListEntry> list) {
        assignedGroupsModel.clear();
        for(GroupListEntry entry: list) {
            addAssignedGroupEntry(entry);
        }
    }
    
    public GroupListEntry getSelectedAvailableGroup() {
        return (GroupListEntry)lstAvailableGroups.getSelectedValue();
    }
    
    public GroupListEntry getSelectedAssignedGroup() {
        return (GroupListEntry)lstGroups.getSelectedValue();
    }
    
    public void addActionListener(ActionListener listener) {
        btnAddGroup.addActionListener(listener);
        btnRemoveGroup.addActionListener(listener);
    }
    
    public void removeActionListener(ActionListener listener) {
        btnAddGroup.removeActionListener(listener);
        btnRemoveGroup.removeActionListener(listener);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        partInformationPanel = new javax.swing.JPanel();
        lblPartName = new javax.swing.JLabel();
        lblIsSpeakingPart = new javax.swing.JLabel();
        lblIsSingingPart = new javax.swing.JLabel();
        jIsSingingPart = new javax.swing.JCheckBox();
        jIsSpeakingPart = new javax.swing.JCheckBox();
        txtPartName = new javax.swing.JTextField();
        groupMembershipPanel = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        lstGroups = new javax.swing.JList();
        jScrollPane3 = new javax.swing.JScrollPane();
        lstAvailableGroups = new javax.swing.JList();
        btnAddGroup = new javax.swing.JButton();
        btnRemoveGroup = new javax.swing.JButton();
        notesPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        txtNotes = new javax.swing.JTextArea();

        jLabel1.setText("jLabel1");

        partInformationPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Part Information"));
        lblPartName.setText("Part Name");

        lblIsSpeakingPart.setText("Speaking Part");

        lblIsSingingPart.setText("Singing Part");

        jIsSingingPart.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jIsSingingPart.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jIsSpeakingPart.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jIsSpeakingPart.setMargin(new java.awt.Insets(0, 0, 0, 0));

        txtPartName.setMinimumSize(new java.awt.Dimension(100, 21));
        txtPartName.setPreferredSize(new java.awt.Dimension(100, 21));

        org.jdesktop.layout.GroupLayout partInformationPanelLayout = new org.jdesktop.layout.GroupLayout(partInformationPanel);
        partInformationPanel.setLayout(partInformationPanelLayout);
        partInformationPanelLayout.setHorizontalGroup(
            partInformationPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(partInformationPanelLayout.createSequentialGroup()
                .add(partInformationPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(lblPartName)
                    .add(lblIsSpeakingPart)
                    .add(lblIsSingingPart))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(partInformationPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jIsSingingPart)
                    .add(jIsSpeakingPart)
                    .add(txtPartName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(365, Short.MAX_VALUE))
        );
        partInformationPanelLayout.setVerticalGroup(
            partInformationPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(partInformationPanelLayout.createSequentialGroup()
                .add(partInformationPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblPartName)
                    .add(txtPartName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 18, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(partInformationPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblIsSpeakingPart)
                    .add(jIsSpeakingPart))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(partInformationPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblIsSingingPart)
                    .add(jIsSingingPart))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        groupMembershipPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Group Membership"));
        lstGroups.setModel(assignedGroupsModel);
        lstGroups.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane2.setViewportView(lstGroups);

        lstAvailableGroups.setModel(availableGroupsModel);
        lstAvailableGroups.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane3.setViewportView(lstAvailableGroups);

        btnAddGroup.setText("<");
        btnAddGroup.setActionCommand("ADD_GROUP");

        btnRemoveGroup.setText(">");
        btnRemoveGroup.setActionCommand("REMOVE_GROUP");

        org.jdesktop.layout.GroupLayout groupMembershipPanelLayout = new org.jdesktop.layout.GroupLayout(groupMembershipPanel);
        groupMembershipPanel.setLayout(groupMembershipPanelLayout);
        groupMembershipPanelLayout.setHorizontalGroup(
            groupMembershipPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(groupMembershipPanelLayout.createSequentialGroup()
                .add(23, 23, 23)
                .add(jScrollPane2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 200, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(groupMembershipPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(btnRemoveGroup, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(btnAddGroup, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 67, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 206, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(27, Short.MAX_VALUE))
        );
        groupMembershipPanelLayout.setVerticalGroup(
            groupMembershipPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, groupMembershipPanelLayout.createSequentialGroup()
                .add(groupMembershipPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 178, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 178, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, groupMembershipPanelLayout.createSequentialGroup()
                        .add(49, 49, 49)
                        .add(btnAddGroup)
                        .add(50, 50, 50)
                        .add(btnRemoveGroup)))
                .addContainerGap())
        );

        notesPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Notes"));
        txtNotes.setColumns(20);
        txtNotes.setLineWrap(true);
        txtNotes.setRows(5);
        txtNotes.setWrapStyleWord(true);
        jScrollPane1.setViewportView(txtNotes);

        org.jdesktop.layout.GroupLayout notesPanelLayout = new org.jdesktop.layout.GroupLayout(notesPanel);
        notesPanel.setLayout(notesPanelLayout);
        notesPanelLayout.setHorizontalGroup(
            notesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 535, Short.MAX_VALUE)
        );
        notesPanelLayout.setVerticalGroup(
            notesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(groupMembershipPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(partInformationPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(notesPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(partInformationPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(groupMembershipPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(notesPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(54, 54, 54))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    void setPartName(String partName) {
        part.setPartName(partName);
        txtPartName.setText(partName);
    }
    
    String getPartName() {
        String partName = txtPartName.getText();
        part.setPartName(partName);
        return partName;
    }
    
    void setIsSpeakingPart(boolean isSpeakingPart) {
        part.setIsSpeakingPart(isSpeakingPart);
        jIsSpeakingPart.setSelected(isSpeakingPart);
    }
    
    boolean getIsSpeakingPart() {
        part.setIsSpeakingPart(jIsSpeakingPart.isSelected());
        return jIsSpeakingPart.isSelected();
    }
    
    void setIsSingingPart(boolean isSingingPart) {
        part.setIsSingingPart(isSingingPart);
        jIsSingingPart.setSelected(isSingingPart);
    }
    
    boolean getIsSingingPart() {
        part.setIsSingingPart(jIsSingingPart.isSelected());
        return jIsSingingPart.isSelected();
    }
    
    void setNotes(String notes) {
        part.setNotes(notes);
        txtNotes.setText(notes);
    }
    
    String getNotes() {
        String notes = txtNotes.getText();
        part.setNotes(notes);
        return notes;
    }
    
    void setId(int id) {
        part.setId(id);
        this.id = id;
    }
    
    int getId() {
        int id = this.id;
        part.setId(id);
        return id;
    }
    
    public void setPart(Part part) {
        if (part != null) {
            setPartName(part.getPartName());
            setIsSpeakingPart(part.getIsSpeakingPart());
            setIsSingingPart(part.getIsSingingPart());
            setNotes(part.getNotes());
            setId(part.getId());
        }
    }
    
    public Part getPart() {
        getPartName();
        getIsSpeakingPart();
        getIsSingingPart();
        getNotes();
        getId();
        return part;
    }
    
    public void clear() {
        txtPartName.setText(null);
        jIsSpeakingPart.setSelected(false);
        jIsSingingPart.setSelected(false);
        assignedGroupsModel.clear();
        availableGroupsModel.clear();
        txtNotes.setText(null);
        
        id = -1;
        part = new Part();
    }
    
    public void setEditable(boolean bEditable) {
        txtPartName.setEditable(bEditable);
        jIsSpeakingPart.setEnabled(bEditable);
        jIsSingingPart.setEnabled(bEditable);
        btnAddGroup.setEnabled(bEditable);
        btnRemoveGroup.setEnabled(bEditable);
        lstGroups.setEnabled(bEditable);
        lstAvailableGroups.setEnabled(bEditable);
        txtNotes.setEditable(bEditable);
        
        isEditable = bEditable;
        txtPartName.requestFocusInWindow();
    }
    
    public boolean isEditable() {
        return isEditable;
    }
    
    public void refreshGroupLists(PartGroupDao partGroupDAO) {
        if (part.getId() != -1) {
            List<GroupListEntry> assignedGroupEntries = partGroupDAO.getAssignedGroupEntries(part.getId());
            this.setAssignedGroupEntries(assignedGroupEntries);
            List<GroupListEntry> availableGroupEntries = partGroupDAO.getAvailableGroupEntries(part.getId());
            this.setAvailableGroupEntries(availableGroupEntries);
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAddGroup;
    private javax.swing.JButton btnRemoveGroup;
    private javax.swing.JPanel groupMembershipPanel;
    private javax.swing.JCheckBox jIsSingingPart;
    private javax.swing.JCheckBox jIsSpeakingPart;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JLabel lblIsSingingPart;
    private javax.swing.JLabel lblIsSpeakingPart;
    private javax.swing.JLabel lblPartName;
    private javax.swing.JList lstAvailableGroups;
    private javax.swing.JList lstGroups;
    private javax.swing.JPanel notesPanel;
    private javax.swing.JPanel partInformationPanel;
    private javax.swing.JTextArea txtNotes;
    private javax.swing.JTextField txtPartName;
    // End of variables declaration//GEN-END:variables
}
