/*
 * AddressPanel.java
 *
 */

package com.sun.demo.addressbook;
import java.text.ParseException;
import java.util.List;
import javax.swing.JFormattedTextField;
import javax.swing.text.MaskFormatter;

/**
 *
 */
public class AddressPanel extends javax.swing.JPanel {
    private PartComboBoxModel partComboBoxModel;
    private PartListEntryRenderer partRenderer;
    int id;
    boolean isEditable;
    MaskFormatter noteInputFormat;
    Address address;
    
    public AddressPanel() {
        partRenderer = new PartListEntryRenderer();
        partComboBoxModel = new PartComboBoxModel();
        noteInputFormat = new MaskFormatter();
        try {
            noteInputFormat = new MaskFormatter("**");
        } catch (ParseException ex) {
            ex.printStackTrace();
        }
        initComponents();
//        inputformat.setValidCharacters(" -0123456789");
//        txtLowVocalNote = new JFormattedTextField(inputformat);
        address = new Address();
    }
    
    public void addPartComboBoxEntry(PartListEntry entry) {
        partComboBoxModel.addElement(entry);
    }
    
    public void addPartComboBoxEntries(List<PartListEntry> list) {
        for(PartListEntry entry: list) {
            addPartComboBoxEntry(entry);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        lblLastName = new javax.swing.JLabel();
        txtLastName = new javax.swing.JTextField();
        lblAddress1 = new javax.swing.JLabel();
        lblCity = new javax.swing.JLabel();
        lblState = new javax.swing.JLabel();
        lblPostalCode = new javax.swing.JLabel();
        txtPostalCode = new javax.swing.JTextField();
        txtState = new javax.swing.JTextField();
        txtAddress1 = new javax.swing.JTextField();
        txtCity = new javax.swing.JTextField();
        lblEmail = new javax.swing.JLabel();
        lblFirstName = new javax.swing.JLabel();
        lblPhone = new javax.swing.JLabel();
        txtEmail = new javax.swing.JTextField();
        txtFirstName = new javax.swing.JTextField();
        txtPhone = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        txtOfficePhone = new javax.swing.JTextField();
        txtCellPhone = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        txtAge = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jOwnsCostume = new javax.swing.JCheckBox();
        jCostumeAtHome = new javax.swing.JCheckBox();
        txtCostumeList = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        lblHeightFeet = new javax.swing.JLabel();
        lblHeightInches = new javax.swing.JLabel();
        txtHeightFeet = new javax.swing.JFormattedTextField();
        txtHeightInches = new javax.swing.JFormattedTextField();
        jPanel4 = new javax.swing.JPanel();
        jcbAssignedPart = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        txtActingScore = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        txtVocalScore = new javax.swing.JTextField();
        jPanel3 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        txtPart2006 = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jSoloAudition = new javax.swing.JCheckBox();
        jLabel10 = new javax.swing.JLabel();
        txtExperienceLevel = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        txtNotes = new javax.swing.JTextArea();
        jLabel11 = new javax.swing.JLabel();
        txtLowVocalNote = new JFormattedTextField(noteInputFormat);
        txtHighVocalNote = new JFormattedTextField(noteInputFormat);

        jLabel1.setText("jLabel1");

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Contact Information"));
        lblLastName.setText("Last Name");

        txtLastName.setMinimumSize(new java.awt.Dimension(100, 21));
        txtLastName.setPreferredSize(new java.awt.Dimension(100, 21));

        lblAddress1.setText("Street");

        lblCity.setText("City");

        lblState.setText("State");

        lblPostalCode.setText("ZIP");

        txtPostalCode.setMinimumSize(new java.awt.Dimension(80, 21));
        txtPostalCode.setPreferredSize(new java.awt.Dimension(80, 21));

        txtState.setMinimumSize(new java.awt.Dimension(30, 21));
        txtState.setPreferredSize(new java.awt.Dimension(30, 21));

        txtCity.setMinimumSize(new java.awt.Dimension(100, 21));
        txtCity.setPreferredSize(new java.awt.Dimension(100, 21));

        lblEmail.setText("Email");

        lblFirstName.setText("First Name");

        lblPhone.setText("Home Phone");

        txtFirstName.setMinimumSize(new java.awt.Dimension(80, 21));
        txtFirstName.setPreferredSize(new java.awt.Dimension(80, 21));

        jLabel5.setText("Office Phone");

        jLabel6.setText("Cell Phone");

        jLabel7.setText("Age (Child)");

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, lblLastName)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, lblAddress1)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, lblCity)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, lblState)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, lblPostalCode)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel7))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(jPanel1Layout.createSequentialGroup()
                                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(txtAddress1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 161, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(txtCity, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 161, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(txtState, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 161, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(txtPostalCode, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                .add(26, 26, 26)
                                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                                    .add(jLabel6)
                                    .add(jLabel5)
                                    .add(lblPhone)
                                    .add(lblEmail)))
                            .add(jPanel1Layout.createSequentialGroup()
                                .add(txtLastName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(lblFirstName)))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(txtEmail, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 170, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, txtCellPhone)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, txtOfficePhone)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, txtPhone, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 113, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(txtFirstName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 112, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(txtAge, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 37, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(102, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(lblLastName)
                        .add(txtLastName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 18, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(lblFirstName)
                        .add(txtFirstName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 18, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(txtAddress1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lblAddress1)
                    .add(lblEmail)
                    .add(txtEmail, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(txtCity, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 18, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lblCity)
                    .add(lblPhone)
                    .add(txtPhone, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(4, 4, 4)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(txtState, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 18, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lblState)
                    .add(jLabel5)
                    .add(txtOfficePhone, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(txtPostalCode, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 18, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lblPostalCode)
                    .add(jLabel6)
                    .add(txtCellPhone, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel7)
                    .add(txtAge, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(22, 22, 22))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Costume Information"));
        jOwnsCostume.setText("Owns Costume");
        jOwnsCostume.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jOwnsCostume.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jCostumeAtHome.setText("LBC Costume at Home");
        jCostumeAtHome.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCostumeAtHome.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jLabel2.setText("Costume List");

        lblHeightFeet.setText("Height (Feet)");

        lblHeightInches.setText("(Inches)");

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(jOwnsCostume)
                        .add(25, 25, 25)
                        .add(jCostumeAtHome)
                        .add(29, 29, 29)
                        .add(jLabel2)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(txtCostumeList, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 266, Short.MAX_VALUE))
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(lblHeightFeet)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(txtHeightFeet, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 42, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(lblHeightInches)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(txtHeightInches, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 41, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jOwnsCostume)
                    .add(jLabel2)
                    .add(txtCostumeList, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jCostumeAtHome))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblHeightFeet)
                    .add(txtHeightFeet, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lblHeightInches)
                    .add(txtHeightInches, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Scores and Part Assignment"));
        jcbAssignedPart.setModel(partComboBoxModel);

        jLabel3.setText("Assigned Part");

        jLabel12.setText("Acting Score");

        jLabel13.setText("Vocal Score");

        org.jdesktop.layout.GroupLayout jPanel4Layout = new org.jdesktop.layout.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel12)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(txtActingScore, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 44, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(28, 28, 28)
                .add(jLabel13)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(txtVocalScore, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 44, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(60, 60, 60)
                .add(jLabel3)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jcbAssignedPart, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 171, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(57, 57, 57))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel4Layout.createSequentialGroup()
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel12)
                    .add(jLabel13)
                    .add(jLabel3)
                    .add(jcbAssignedPart, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(txtVocalScore, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(txtActingScore, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Experience"));
        jLabel4.setText("LPP 2006 Part");

        jLabel8.setText("Vocal Range");

        jLabel9.setText("to");

        jSoloAudition.setText("Auditioned for a Solo");
        jSoloAudition.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jSoloAudition.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jLabel10.setText("Experience Level");

        txtNotes.setColumns(20);
        txtNotes.setLineWrap(true);
        txtNotes.setRows(5);
        txtNotes.setTabSize(0);
        txtNotes.setWrapStyleWord(true);
        jScrollPane1.setViewportView(txtNotes);

        jLabel11.setText("Notes");

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jLabel4)
                    .add(jLabel11)
                    .add(jLabel8))
                .add(4, 4, 4)
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel3Layout.createSequentialGroup()
                        .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(txtPart2006, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 146, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jPanel3Layout.createSequentialGroup()
                                .add(txtLowVocalNote, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 42, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel9)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(txtHighVocalNote, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 45, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                        .add(66, 66, 66)
                        .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel3Layout.createSequentialGroup()
                                .add(jLabel10)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(txtExperienceLevel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 77, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jPanel3Layout.createSequentialGroup()
                                .add(10, 10, 10)
                                .add(jSoloAudition))))
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 507, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(26, 26, 26))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel4)
                    .add(txtPart2006, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel10)
                    .add(txtExperienceLevel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel8)
                    .add(jSoloAudition)
                    .add(txtLowVocalNote, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel9)
                    .add(txtHighVocalNote, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel3Layout.createSequentialGroup()
                        .add(jLabel11)
                        .addContainerGap(68, Short.MAX_VALUE))
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 82, Short.MAX_VALUE)))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel3, 0, 623, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 179, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(17, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    void setLastName(String lastName) {
        address.setLastName(lastName);
        txtLastName.setText(lastName);
    }
    
    String getLastName() {
        String lastName = txtLastName.getText();
        address.setLastName(lastName);
        return lastName;
    }
    
    void setFirstName(String firstName) {
        address.setFirstName(firstName);
        txtFirstName.setText(firstName);
        
    }
    
    String getFirstName() {
        String firstName = txtFirstName.getText();
        address.setFirstName(firstName);
        return firstName;
    }
    
    void setPhone(String phone) {
        address.setPhone(phone);
        txtPhone.setText(phone);
    }
    
    String getPhone() {
        String phone = txtPhone.getText();
        address.setPhone(phone);
        return phone;
    }
    
    void setOfficePhone(String officePhone) {
        address.setOfficePhone(officePhone);
        txtOfficePhone.setText(officePhone);
    }
    
    String getOfficePhone() {
        String officePhone = txtOfficePhone.getText();
        address.setOfficePhone(officePhone);
        return officePhone;
    }
    
    void setCellPhone(String cellPhone) {
        address.setCellPhone(cellPhone);
        txtCellPhone.setText(cellPhone);
    }
    
    String getCellPhone() {
        String cellPhone = txtCellPhone.getText();
        address.setCellPhone(cellPhone);
        return cellPhone;
    }
    
    void setEmail(String email) {
        address.setEmail(email);
        txtEmail.setText(email);
    }
    
    String getEmail() {
        String email = txtEmail.getText();
        address.setEmail(email);
        return email;
    }
    
    void setAddress1(String address1) {
        address.setAddress1(address1);
        txtAddress1.setText(address1);
    }
    
    String getAddress1() {
        String address1 = txtAddress1.getText();
        address.setAddress1(address1);
        return address1;
    }
    
    void setCity(String city) {
        address.setCity(city);
        txtCity.setText(city);
    }
    
    String getCity() {
        String city = txtCity.getText();
        address.setCity(city);
        return city;
    }
    
    /**
     * Sets the internal address object and the UI display value to the string
     */
    void setState(String state) {
        address.setState(state);
        txtState.setText(state);
    }
    
    /**
     * Gets the UI display value of the property and sets the internal address
     * object property.
     *
     * Gets from the UI, and makes sure the internal object is consistent
     */
    String getState() {
        String state = txtState.getText();
        address.setState(state);
        return state;
    }
    
    void setPostalCode(String postalCode) {
        address.setPostalCode(postalCode);
        txtPostalCode.setText(postalCode);
    }
    
    String getPostalCode() {
        String postalCode = txtPostalCode.getText();
        address.setPostalCode(postalCode);
        return postalCode;
    }
    
    void setAge(int age) {
        address.setAge(age);
        txtAge.setText(String.valueOf(age));
    }
    
    String getAge() {
        String age = txtAge.getText();
        if (! age.equals("")) {
            address.setAge(Integer.parseInt(age));
        } else {
            address.setAge(0);
        }
        return age;
    }
    
    public void setHeightFeet(String heightFeet) {
        address.setHeightFeet(heightFeet);
        txtHeightFeet.setText(heightFeet);
    }
    
    public String getHeightFeet() {
        String heightFeet = txtHeightFeet.getText();
        address.setHeightFeet(heightFeet);
        return heightFeet;
    }
    
    public void setHeightInches(String heightInches) {
        address.setHeightInches(heightInches);
        txtHeightInches.setText(heightInches);
    }
    
    public String getHeightInches() {
        String heightInches = txtHeightInches.getText();
        address.setHeightInches(heightInches);
        return heightInches;
    }
    
    void setOwnsCostume(boolean ownsCostume) {
        address.setOwnsCostume(ownsCostume);
        jOwnsCostume.setSelected(ownsCostume);
    }
    
    boolean getOwnsCostume() {
        boolean ownsCostume = jOwnsCostume.isSelected();
        address.setOwnsCostume(ownsCostume);
        return ownsCostume;
    }
    
    void setCostumeAtHome(boolean costumeAtHome) {
        address.setCostumeAtHome(costumeAtHome);
        jCostumeAtHome.setSelected(costumeAtHome);
    }
    
    boolean getCostumeAtHome() {
        address.setCostumeAtHome(jCostumeAtHome.isSelected());
        return jCostumeAtHome.isSelected();
    }
    
    void setCostumeList(String costumeList) {
        address.setCostumeList(costumeList);
        txtCostumeList.setText(costumeList);
    }
    
    String getCostumeList() {
        String costumeList = txtCostumeList.getText();
        address.setCostumeList(costumeList);
        return costumeList;
    }
    
    void setPart2006(String part2006) {
        address.setPart2006(part2006);
        txtPart2006.setText(part2006);
    }
    
    String getPart2006() {
        String part2006 = txtPart2006.getText();
        address.setPart2006(part2006);
        return part2006;
    }
    
    void setSoloAudition(boolean soloAudition) {
        address.setSoloAudition(soloAudition);
        jSoloAudition.setSelected(soloAudition);
    }
    
    boolean getSoloAudition() {
        address.setSoloAudition(jSoloAudition.isSelected());
        return jSoloAudition.isSelected();
    }
    
    void setLowVocalNote(String lowVocalNote) {
        address.setLowVocalNote(lowVocalNote);
        txtLowVocalNote.setText(lowVocalNote);
    }
    
    String getLowVocalNote() {
        String lowVocalNote = txtLowVocalNote.getText();
        address.setLowVocalNote(lowVocalNote);
        return lowVocalNote;
    }
    
    void setHighVocalNote(String highVocalNote) {
        address.setHighVocalNote(highVocalNote);
        txtHighVocalNote.setText(highVocalNote);
    }
    
    String getHighVocalNote() {
        String highVocalNote = txtHighVocalNote.getText();
        address.setHighVocalNote(highVocalNote);
        return highVocalNote;
    }
    
    void setExperienceLevel(int experienceLevel) {
        address.setExperienceLevel(experienceLevel);
        txtExperienceLevel.setText(String.valueOf(experienceLevel));
    }
    
    String getExperienceLevel() {
        String experienceLevel = txtExperienceLevel.getText();
        if (! experienceLevel.equals("")) {
            address.setExperienceLevel(Integer.parseInt(experienceLevel));
        } else {
            address.setExperienceLevel(0);
        }
        return experienceLevel;
    }
    
    /**
     * Sets the internal address object and the UI display value
     */
    void setAssignedPart(int assignedPart) {
        address.setAssignedPart(assignedPart);
        PartListEntry entryForId = partComboBoxModel.getObjectByPartId(assignedPart);
        partComboBoxModel.setSelectedItem(entryForId);
//        jcbAssignedPart.setSelectedItem();
    }
    
    /**
     * Gets the UI display value of the property and sets the internal address
     * object property.
     *
     * Gets from the UI, and makes sure the internal object is consistent
     */
    private int getAssignedPart() {
        int assignedPart = -1;
        PartListEntry entry = (PartListEntry)jcbAssignedPart.getSelectedItem();
        if (entry != null) {
            address.setAssignedPart(entry.getId());
            assignedPart = entry.getId();
        }
        return assignedPart;
    }
    
    void setActingScore(String actingScore) {
        address.setActingScore(actingScore);
        txtActingScore.setText(actingScore);
    }
    
    String getActingScore() {
        String actingScore = txtActingScore.getText();
        address.setActingScore(actingScore);
        return actingScore;
    }
    
    void setVocalScore(String vocalScore) {
        address.setVocalScore(vocalScore);
        txtVocalScore.setText(vocalScore);
    }
    
    String getVocalScore() {
        String vocalScore = txtVocalScore.getText();
        address.setVocalScore(vocalScore);
        return vocalScore;
    }
    
    void setNotes(String notes) {
        address.setNotes(notes);
        txtNotes.setText(notes);
    }
    
    String getNotes() {
        String notes = txtNotes.getText();
        address.setNotes(notes);
        return notes;
    }
    
    void setId(int id) {
        address.setId(id);
        this.id = id;
    }
    
    int getId() {
        int id = this.id;
        address.setId(id);
        return id;
    }
    
    
    public void setAddress(Address address) {
        if (address != null) {
            setLastName(address.getLastName());
            setFirstName(address.getFirstName());
            setPhone(address.getPhone());
            setOfficePhone(address.getOfficePhone());
            setCellPhone(address.getCellPhone());
            setEmail(address.getEmail());
            setAddress1(address.getAddress1());
            setCity(address.getCity());
            setState(address.getState());
            setPostalCode(address.getPostalCode());
            setAge(address.getAge());
            setHeightFeet(address.getHeightFeet());
            setHeightInches(address.getHeightInches());
            setOwnsCostume(address.getOwnsCostume());
            setCostumeAtHome(address.getCostumeAtHome());
            setCostumeList(address.getCostumeList());
            setPart2006(address.getPart2006());
            setLowVocalNote(address.getLowVocalNote());
            setHighVocalNote(address.getHighVocalNote());
            setExperienceLevel(address.getExperienceLevel());
            setAssignedPart(address.getAssignedPart());
            setVocalScore(address.getVocalScore());
            setActingScore(address.getActingScore());
            setNotes(address.getNotes());
            setId(address.getId());
        }
    }
    
    /**
     * Gets all of the values from the UI and returns an address object with the
     * UI values.
     */
    public Address getAddress() {
        getLastName();
        getFirstName();
        getPhone();
        getOfficePhone();
        getCellPhone();
        getEmail();
        getAddress1();
        getCity();
        getState();
        getPostalCode();
        getAge();
        getHeightFeet();
        getHeightInches();
        getOwnsCostume();
        getCostumeAtHome();
        getCostumeList();
        getPart2006();
        getSoloAudition();
        getLowVocalNote();
        getHighVocalNote();
        getExperienceLevel();
        getAssignedPart();
        getActingScore();
        getVocalScore();
        getNotes();
        getId();
        return address;
    }
    
    public void clear() {
        txtLastName.setText(null);
        txtFirstName.setText(null);
        txtPhone.setText(null);
        txtOfficePhone.setText(null);
        txtCellPhone.setText(null);
        txtEmail.setText(null);
        txtAddress1.setText(null);
        txtCity.setText("Lexington");
        txtState.setText("SC");
        txtPostalCode.setText(null);
        txtAge.setText(null);
        txtHeightFeet.setText(null);
        txtHeightInches.setText(null);
        jCostumeAtHome.setSelected(false);
        jOwnsCostume.setSelected(false);
        txtCostumeList.setText(null);
        txtPart2006.setText(null);
        jSoloAudition.setSelected(false);
        txtLowVocalNote.setText(null);
        txtHighVocalNote.setText(null);
        txtExperienceLevel.setText(null);
        jcbAssignedPart.setSelectedIndex(-1);
        txtActingScore.setText(null);
        txtVocalScore.setText(null);
        txtNotes.setText(null);
        
        id = -1;
        address = new Address();
    }
    
    public void setEditable(boolean bEditable) {
        txtLastName.setEditable(bEditable);
        txtFirstName.setEditable(bEditable);
        txtPhone.setEditable(bEditable);
        txtOfficePhone.setEditable(bEditable);
        txtCellPhone.setEditable(bEditable);
        txtEmail.setEditable(bEditable);
        txtAddress1.setEditable(bEditable);
        txtCity.setEditable(bEditable);
        txtState.setEditable(bEditable);
        txtPostalCode.setEditable(bEditable);
        txtAge.setEditable(bEditable);
        txtHeightFeet.setEditable(bEditable);
        txtHeightInches.setEditable(bEditable);
        jOwnsCostume.setEnabled(bEditable);
        jCostumeAtHome.setEnabled(bEditable);
        txtCostumeList.setEditable(bEditable);
        txtPart2006.setEditable(bEditable);
        jSoloAudition.setEnabled(bEditable);
        txtLowVocalNote.setEditable(bEditable);
        txtHighVocalNote.setEditable(bEditable);
        txtExperienceLevel.setEditable(bEditable);
        jcbAssignedPart.setEnabled(bEditable);
        txtActingScore.setEditable(bEditable);
        txtVocalScore.setEditable(bEditable);
        txtNotes.setEditable(bEditable);
        
        isEditable = bEditable;
        txtLastName.requestFocusInWindow();
    }
    
    public boolean isEditable() {
        return isEditable;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JCheckBox jCostumeAtHome;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JCheckBox jOwnsCostume;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JCheckBox jSoloAudition;
    private javax.swing.JComboBox jcbAssignedPart;
    private javax.swing.JLabel lblAddress1;
    private javax.swing.JLabel lblCity;
    private javax.swing.JLabel lblEmail;
    private javax.swing.JLabel lblFirstName;
    private javax.swing.JLabel lblHeightFeet;
    private javax.swing.JLabel lblHeightInches;
    private javax.swing.JLabel lblLastName;
    private javax.swing.JLabel lblPhone;
    private javax.swing.JLabel lblPostalCode;
    private javax.swing.JLabel lblState;
    private javax.swing.JTextField txtActingScore;
    private javax.swing.JTextField txtAddress1;
    private javax.swing.JTextField txtAge;
    private javax.swing.JTextField txtCellPhone;
    private javax.swing.JTextField txtCity;
    private javax.swing.JTextField txtCostumeList;
    private javax.swing.JTextField txtEmail;
    private javax.swing.JTextField txtExperienceLevel;
    private javax.swing.JTextField txtFirstName;
    private javax.swing.JFormattedTextField txtHeightFeet;
    private javax.swing.JFormattedTextField txtHeightInches;
    private javax.swing.JFormattedTextField txtHighVocalNote;
    private javax.swing.JTextField txtLastName;
    private javax.swing.JFormattedTextField txtLowVocalNote;
    private javax.swing.JTextArea txtNotes;
    private javax.swing.JTextField txtOfficePhone;
    private javax.swing.JTextField txtPart2006;
    private javax.swing.JTextField txtPhone;
    private javax.swing.JTextField txtPostalCode;
    private javax.swing.JTextField txtState;
    private javax.swing.JTextField txtVocalScore;
    // End of variables declaration//GEN-END:variables
}
