/*
 * AddressActionPanel.java
 *
 * Copyright 2006 Sun Microsystems, Inc. ALL RIGHTS RESERVED Use of 
 * this software is authorized pursuant to the terms of the license 
 * found at http://developers.sun.com/berkeley_license.html .
 */

package com.sun.demo.addressbook;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.EventListenerList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 *
 * @author  John O'Conner
 */
public class AddressActionPanel extends javax.swing.JPanel  {
    
    /**
     * Creates new form AddressActionPanel
     */
    public AddressActionPanel() {
        initComponents();
        listeners = new EventListenerList();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        btnNewAddress = new javax.swing.JButton();
        btnSaveAddress = new javax.swing.JButton();
        btnEditAddress = new javax.swing.JButton();
        btnCancelAddress = new javax.swing.JButton();
        btnDeleteAddress = new javax.swing.JButton();

        setLayout(new java.awt.GridLayout(1, 0));

        btnNewAddress.setText("New");
        btnNewAddress.setActionCommand("NEW_ADDRESS");
        btnNewAddress.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newAddressActionPerformed(evt);
            }
        });

        add(btnNewAddress);

        btnSaveAddress.setText("Save");
        btnSaveAddress.setActionCommand("SAVE_ADDRESS");
        btnSaveAddress.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveAddressActionPerformed(evt);
            }
        });

        add(btnSaveAddress);

        btnEditAddress.setText("Edit");
        btnEditAddress.setActionCommand("EDIT_ADDRESS");
        btnEditAddress.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editAddressActionPerformed(evt);
            }
        });

        add(btnEditAddress);

        btnCancelAddress.setText("Cancel");
        btnCancelAddress.setActionCommand("CANCEL_ADDRESS");
        btnCancelAddress.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelAddressActionPerformed(evt);
            }
        });

        add(btnCancelAddress);

        btnDeleteAddress.setText("Delete");
        btnDeleteAddress.setActionCommand("DELETE_ADDRESS");
        btnDeleteAddress.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteAddressActionPerformed(evt);
            }
        });

        add(btnDeleteAddress);

    }// </editor-fold>//GEN-END:initComponents

    private void cancelAddressActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelAddressActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_cancelAddressActionPerformed

    private void saveAddressActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveAddressActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_saveAddressActionPerformed

    private void editAddressActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editAddressActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_editAddressActionPerformed

    private void deleteAddressActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteAddressActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_deleteAddressActionPerformed

    private void newAddressActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newAddressActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_newAddressActionPerformed

    private void fireActionEvent(ActionEvent evt) {
        ActionListener[] listenerList = listeners.getListeners(ActionListener.class);

        for (int i = listenerList.length-1; i>=0; --i) {
            listenerList[i].actionPerformed(evt);
        }
        
    }
    
    public void addActionListener(ActionListener listener) {
        listeners.add(ActionListener.class, listener);
    }
    
    public void removeActionListener(ActionListener listener) {
        if (listeners != null) {
            listeners.remove(ActionListener.class, listener);
        }
    }
    
    EventListenerList listeners;
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCancelAddress;
    private javax.swing.JButton btnDeleteAddress;
    private javax.swing.JButton btnEditAddress;
    private javax.swing.JButton btnNewAddress;
    private javax.swing.JButton btnSaveAddress;
    // End of variables declaration//GEN-END:variables
    
}
