/*
 * Address.java
 *
 */
package org.lpp;

/**
 *
 */
public class Address {
    private String lastName;
    private String firstName;
    private String middleName;
    private String phone;
    private String officePhone;
    private String cellPhone;
    private String email;
    private String address1;
    private String city;
    private String state;
    private String postalCode;
    private int age;
    private String heightFeet;
    private String heightInches;
    private boolean ownsCostume;
    private boolean costumeAtHome;
    private String costumeList;
    private String part2006;
    private boolean soloAudition;
    private String lowVocalNote;
    private String highVocalNote;
    private int experienceLevel;
    private int assignedPart;
    private String actingScore;
    private String vocalScore;
    private String notes;
    private int id;
    private static final int PRIMENO = 37;
    
    /**
     * Creates a new instance of Address
     */
    public Address() {
    }
    
    public Address(String lastName, String firstName, String middleName,
            String phone, String officePhone, String cellPhone, String email,
            String address1, String city, String state, String postalCode,
            int age, String heightFeet, String heightInches, boolean ownsCostume, 
            boolean costumeAtHome, String costumeList,
            String part2006, boolean soloAudition, String lowVocalNote,
            String highVocalNote, int experienceLevel, int assignedPart,
            String actingScore, String vocalScore,
            String notes, int id) {
        this.lastName = lastName;
        this.firstName = firstName;
        this.middleName = middleName;
        this.phone = phone;
        this.officePhone = officePhone;
        this.cellPhone = cellPhone;
        this.email = email;
        this.address1 = address1;
        this.city = city;
        this.state = state;
        this.postalCode = postalCode;
        this.age = age;
        this.setHeightFeet(heightFeet);
        this.setHeightInches(heightInches);
        this.ownsCostume = ownsCostume;
        this.costumeAtHome = costumeAtHome;
        this.costumeList = costumeList;
        this.setPart2006(part2006);
        this.setSoloAudition(soloAudition);
        this.setLowVocalNote(lowVocalNote);
        this.setHighVocalNote(highVocalNote);
        this.setExperienceLevel(experienceLevel);
        this.assignedPart = assignedPart;
        this.actingScore = actingScore;
        this.vocalScore = vocalScore;
        this.setNotes(notes);
        this.id = id;
    }
    
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
    
    public String getLastName() {
        return lastName;
    }
    
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }
    
    public String getFirstName() {
        return firstName;
    }
    
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }
    
    public String getMiddleName() {
        return middleName;
    }
    
    public void setPhone(String phone) {
        this.phone = phone;
    }
    
    public String getPhone() {
        return phone;
    }
    
    public void setOfficePhone(String officePhone) {
        this.officePhone = officePhone;
    }
    
    public String getOfficePhone() {
        return officePhone;
    }
    
    public void setCellPhone(String cellPhone) {
        this.cellPhone = cellPhone;
    }
    
    public String getCellPhone() {
        return cellPhone;
    }
    
    public void setEmail(String email) {
        this.email = email;
    }
    
    public String getEmail() {
        return email;
    }
    
    public void setId(int id) {
        this.id = id;
    }
    
    public int getId() {
        return id;
    }
    
    public String getAddress1() {
        return this.address1;
    }
    
    public void setAddress1(String address1) {
        this.address1 = address1;
    }
    
    public String getCity() {
        return this.city;
    }
    
    public void setCity(String city) {
        this.city = city;
    }
    
    public String getState() {
        return this.state;
    }
    
    public void setState(String state) {
        this.state = state;
    }
    
    public String getPostalCode() {
        return this.postalCode;
    }
    
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }
    
    public int getAge() {
        return this.age;
    }
    
    public void setAge(int age) {
        this.age = age;
    }
    
    public String getHeightFeet() {
        return heightFeet;
    }

    public void setHeightFeet(String heightFeet) {
        this.heightFeet = heightFeet;
    }

    public String getHeightInches() {
        return heightInches;
    }

    public void setHeightInches(String heightInches) {
        this.heightInches = heightInches;
    }
    public boolean getOwnsCostume() {
        return this.ownsCostume;
    }
    
    public void setOwnsCostume(boolean ownsCostume) {
        this.ownsCostume = ownsCostume;
    }
    
    public boolean getCostumeAtHome() {
        return this.costumeAtHome;
    }
    
    public void setCostumeAtHome(boolean costumeAtHome) {
        this.costumeAtHome = costumeAtHome;
    }
    
    public String getCostumeList() {
        return this.costumeList;
    }
    
    public void setCostumeList(String costumeList) {
        this.costumeList = costumeList;
    }
    
    public int getAssignedPart() {
        return this.assignedPart;
    }
    
    public void setAssignedPart(int assignedPart) {
        this.assignedPart = assignedPart;
    }
    
    public String getPart2006() {
        return part2006;
    }

    public void setPart2006(String part2006) {
        this.part2006 = part2006;
    }

    public boolean getSoloAudition() {
        return soloAudition;
    }

    public void setSoloAudition(boolean soloAudition) {
        this.soloAudition = soloAudition;
    }

    public String getLowVocalNote() {
        return lowVocalNote;
    }

    public void setLowVocalNote(String lowVocalNote) {
        this.lowVocalNote = lowVocalNote;
    }

    public String getHighVocalNote() {
        return highVocalNote;
    }

    public void setHighVocalNote(String highVocalNote) {
        this.highVocalNote = highVocalNote;
    }

    public int getExperienceLevel() {
        return experienceLevel;
    }

    public void setExperienceLevel(int experienceLevel) {
        this.experienceLevel = experienceLevel;
    }

    public String getActingScore() {
        return actingScore;
    }

    public void setActingScore(String actingScore) {
        this.actingScore = actingScore;
    }

    public String getVocalScore() {
        return vocalScore;
    }

    public void setVocalScore(String vocalScore) {
        this.vocalScore = vocalScore;
    }

    public String getNotes() {
        return notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public int hashCode() {
        int value = 1;
        value = value*PRIMENO + (lastName == null ? 0 : lastName.hashCode());
        value = value*PRIMENO + (middleName == null ? 0 : middleName.hashCode());
        value = value*PRIMENO + (firstName == null ? 0 : firstName.hashCode());
        value = value*PRIMENO + (phone == null ? 0 : phone.hashCode());
        value = value*PRIMENO + (email == null ? 0 : email.hashCode());
        value = value*PRIMENO + (address1 == null ? 0 : address1.hashCode());
        value = value*PRIMENO + (city == null ? 0 : city.hashCode());
        value = value*PRIMENO + (state == null ? 0 : state.hashCode());
        value = value*PRIMENO + (postalCode == null ? 0 : postalCode.hashCode());
        value = value*PRIMENO + (costumeList == null ? 0 : costumeList.hashCode());
        value = value*PRIMENO + (actingScore == null ? 0 : actingScore.hashCode());
        value = value*PRIMENO + (vocalScore == null ? 0 : vocalScore.hashCode());
        return value;
    }
    
    public boolean equals(Object other) {
        boolean bEqual = false;
        if (this == other) {
            bEqual = true;
        } else if (other instanceof Address) {
            Address thatAddress = (Address) other;
            if ((lastName == null ? thatAddress.lastName == null : lastName.equalsIgnoreCase(thatAddress.lastName)) &&
                    (firstName == null ? thatAddress.firstName == null : firstName.equalsIgnoreCase(thatAddress.firstName)) &&
                    (middleName == null ? thatAddress.middleName == null : middleName.equalsIgnoreCase(thatAddress.middleName)) &&
                    (phone == null ? thatAddress.phone == null : phone.equalsIgnoreCase(thatAddress.phone)) &&
                    (email == null ? thatAddress.email == null : email.equalsIgnoreCase(thatAddress.email)) &&
                    (address1 == null ? thatAddress.address1 == null : address1.equalsIgnoreCase(thatAddress.address1)) &&
                    (city == null ? thatAddress.city == null : city.equalsIgnoreCase(thatAddress.city)) &&
                    (state == null ? thatAddress.state == null : state.equalsIgnoreCase(thatAddress.state)) &&
                    (postalCode == null ? thatAddress.postalCode == null : postalCode.equalsIgnoreCase(thatAddress.postalCode)) &&
                    (costumeList == null ? thatAddress.costumeList == null : costumeList.equalsIgnoreCase(thatAddress.costumeList)) &&
                    (vocalScore == null ? thatAddress.vocalScore == null : costumeList.equalsIgnoreCase(thatAddress.vocalScore)) &&
                    (actingScore == null ? thatAddress.actingScore == null : actingScore.equalsIgnoreCase(thatAddress.actingScore))) {
                bEqual = true;
            }
        }
        return bEqual;
    }
}
