/*
 * AddressPanel.java
 *
 */
package org.lpp;

import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.List;
import javax.swing.text.MaskFormatter;

/**
 *
 */
public class GroupPanel extends javax.swing.JPanel {
    private PartComboBoxModel partComboBoxModel;
    private PartListEntryRenderer partRenderer;
    int id;
    boolean isEditable;
    MaskFormatter noteInputFormat;
    Group group;
    
    public GroupPanel() {
        partRenderer = new PartListEntryRenderer();
        partComboBoxModel = new PartComboBoxModel();
        noteInputFormat = new MaskFormatter();
        try {
            noteInputFormat = new MaskFormatter("**");
        } catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        initComponents();
//        inputformat.setValidCharacters(" -0123456789");
//        txtLowVocalNote = new JFormattedTextField(inputformat);
        group = new Group();
    }
    
    public void addActionListener(ActionListener listener) {
        btnEmailGroup.addActionListener(listener);
    }
    
    public void removeActionListener(ActionListener listener) {
        btnEmailGroup.removeActionListener(listener);
    }

    public void addPartComboBoxEntry(PartListEntry entry) {
        partComboBoxModel.addElement(entry);
    }
    
    public void addPartComboBoxEntries(List<PartListEntry> list) {
        for(PartListEntry entry: list) {
            addPartComboBoxEntry(entry);
        }
    }
    
    void enableEmail() {
        btnEmailGroup.setEnabled(true);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        lblGroupName = new javax.swing.JLabel();
        txtGroupName = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        txtGroupNotes = new javax.swing.JTextArea();
        jLabel4 = new javax.swing.JLabel();
        emailPanel = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        btnEmailGroup = new javax.swing.JButton();
        lblEmailStatus = new javax.swing.JLabel();

        jLabel1.setText("jLabel1");

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Group Information"));
        lblGroupName.setText("Group Name");

        txtGroupName.setMinimumSize(new java.awt.Dimension(100, 21));
        txtGroupName.setPreferredSize(new java.awt.Dimension(100, 21));

        txtGroupNotes.setColumns(20);
        txtGroupNotes.setLineWrap(true);
        txtGroupNotes.setRows(5);
        txtGroupNotes.setTabSize(0);
        txtGroupNotes.setWrapStyleWord(true);
        jScrollPane1.setViewportView(txtGroupNotes);

        jLabel4.setText("Notes");

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel4)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, lblGroupName))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(txtGroupName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 182, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 507, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(34, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblGroupName)
                    .add(txtGroupName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 18, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(jLabel4)
                        .addContainerGap())
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)))
        );

        emailPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Email"));
        jLabel2.setText("Email this Group");

        btnEmailGroup.setText("Email");
        btnEmailGroup.setActionCommand("EMAIL_GROUP");
        btnEmailGroup.setEnabled(false);

        org.jdesktop.layout.GroupLayout emailPanelLayout = new org.jdesktop.layout.GroupLayout(emailPanel);
        emailPanel.setLayout(emailPanelLayout);
        emailPanelLayout.setHorizontalGroup(
            emailPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(emailPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(btnEmailGroup)
                .add(27, 27, 27)
                .add(lblEmailStatus, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 430, Short.MAX_VALUE)
                .addContainerGap())
        );
        emailPanelLayout.setVerticalGroup(
            emailPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(emailPanelLayout.createSequentialGroup()
                .add(emailPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(btnEmailGroup)
                    .add(lblEmailStatus))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, emailPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(emailPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(224, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    void setGroupName(String groupName) {
        group.setGroupName(groupName);
        txtGroupName.setText(groupName);
    }
    
    String getGroupName() {
        String groupName = txtGroupName.getText();
        group.setGroupName(groupName);
        return groupName;
    }
    
    void setNotes(String notes) {
        group.setNotes(notes);
        txtGroupNotes.setText(notes);
    }
    
    String getNotes() {
        String notes = txtGroupNotes.getText();
        group.setNotes(notes);
        return notes;
    }
    
    void setId(int id) {
        group.setId(id);
        this.id = id;
    }
    
    int getId() {
        int id = this.id;
        group.setId(id);
        return id;
    }
    
    public void setGroup(Group group) {
        if (group != null) {
            setGroupName(group.getGroupName());
            setNotes(group.getNotes());
            setId(group.getId());
        }
    }
    
    /**
     * Gets all of the values from the UI and returns an address object with the
     * UI values.
     */
    public Group getGroup() {
        getGroupName();
        getNotes();
        getId();
        return group;
    }
    
    public void clear() {
        txtGroupName.setText(null);
        txtGroupNotes.setText(null);
        
        id = -1;
        group = new Group();
    }
    
    public void setEditable(boolean bEditable) {
        txtGroupName.setEditable(bEditable);
        txtGroupNotes.setEditable(bEditable);
        
        isEditable = bEditable;
        txtGroupName.requestFocusInWindow();
    }
    
    public boolean isEditable() {
        return isEditable;
    }

    public void setLblEmailStatus(String emailStatusText) {
        this.lblEmailStatus.setText(emailStatusText);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnEmailGroup;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JPanel emailPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblEmailStatus;
    private javax.swing.JLabel lblGroupName;
    private javax.swing.JTextField txtGroupName;
    private javax.swing.JTextArea txtGroupNotes;
    // End of variables declaration//GEN-END:variables
}
