/*
 * ListEntry.java
 *
 */

package org.lpp;

import org.lpp.util.HashCodeUtil;

/**
 *
 */
public class PartListEntry implements Comparable<PartListEntry> {
    
    private String partName;
    private int id;
    
    /** Creates a new instance of ListEntry */
    public PartListEntry() {
        this("", -1);
    }
    
    public PartListEntry(String partName, int id) {
        this.partName = partName;
        this.id = id;
    }
    
    public String getName() {
        return partName;
    }
    
    public String getPartName() {
        return partName;
    }
    
    public void setPartName(String partName) {
        this.partName = partName;
    }
    
    public int getId() {
        return id;
    }
    
    public void setId(int id) {
        this.id = id;
    }
    
    public String toString( ){
        String value = partName;
        return value;
    }
    
    public int hashCode() {
        int result = HashCodeUtil.SEED;
        result = HashCodeUtil.hash( result, partName );
        result = HashCodeUtil.hash( result, id );
        return result;
    }
    
    public boolean equals(Object entry) {
        if (entry == null) {
            return false;
        }
        if (entry instanceof PartListEntry) {
            return this.equals((PartListEntry)entry);
        } else {
            return false;
        }
    }
    
    public boolean equals(PartListEntry entry) {
        boolean result = true;
        if (! this.partName.equals(entry.getPartName())) {
            result = false;
        }
        if (this.id != entry.getId()) {
            result = false;
        }
        return result;
    }
    
    public int compareTo(PartListEntry entry) {
        return this.getPartName().compareTo(entry.getPartName());
    }
}