/*
 * LppDbSetup.java
 *
 */

package org.lpp.db;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Properties;

/**
 *
 * @author rhisld
 */
public class LppDbBackup {
    private LppDbSetup lppDbSetup;
    private Connection dbConnection;
    private boolean isConnected;
    
    private LppDbBackup() {
        lppDbSetup = LppDbSetup.getLppDbSetup();
        System.out.println("LPP Database Backup");
    }
    
    public boolean connect() {
        String dbUrl = lppDbSetup.getDatabaseUrl();
        try {
            dbConnection = DriverManager.getConnection(dbUrl, lppDbSetup.getDatabaseProperties());
            isConnected = true;
        } catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return isConnected;
    }
    
    public void disconnect() {
        if(isConnected) {
            try {
                dbConnection.commit();
                dbConnection.close();
            } catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            isConnected = false;
        }
    }
    
    public static void main(String[] args) throws SQLException {
        LppDbBackup lppDbBackup = new LppDbBackup();
        lppDbBackup.connect();
        CallableStatement cs = lppDbBackup.dbConnection.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        cs.setString(1, "C:\\Documents and Settings\\rhisld\\My Documents\\Projects\\Database-Backups\\2006.01.06C");
        cs.execute();
        cs.close();
        lppDbBackup.disconnect();
    }
}
