/*
 * PartListEntryTest.java
 * JUnit based test
 *
 * Created on January 20, 2007, 7:19 PM
 */
package org.lpp;

import junit.framework.*;

/**
 *
 * @author rhisld
 */
public class PartListEntryTest extends TestCase {
    
    public PartListEntryTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    /**
     * Test of getName method, of class org.lpp.PartListEntry.
     */
    public void testGetName() {
        PartListEntry instance = new PartListEntry();
        String expResult = "Peter";
        instance.setPartName("Peter");

        String result = instance.getName();
        assertEquals(expResult, result);

        instance = new PartListEntry("Thomas", 943);
        expResult = "Thomas";
        int expId = 943;

        result = instance.getName();
        int id = instance.getId();
        assertEquals(expResult, result);
        assertEquals(expId, id);
    }

    /**
     * Test of getPartName method, of class org.lpp.PartListEntry.
     */
    public void testGetPartName() {
        PartListEntry instance = new PartListEntry();
        String expResult = "Peter";
        instance.setPartName("Peter");

        String result = instance.getPartName();
        assertEquals(expResult, result);

        instance = new PartListEntry("Thomas", 942);
        expResult = "Thomas";
        int expId = 942;

        result = instance.getPartName();
        int id = instance.getId();
        assertEquals(expResult, result);
        assertEquals(expId, id);
    }

    /**
     * Test of toString method, of class org.lpp.PartListEntry.
     */
    public void testToString() {
        PartListEntry instance = new PartListEntry("John", 212);
        
        String expResult = "John";
        String result = instance.toString();
        assertEquals(expResult, result);
    }

    /**
     * Test of compareTo method, of class org.lpp.PartListEntry.
     */
    public void testCompareTo() {
        PartListEntry first = new PartListEntry("A Part", 989);
        PartListEntry second = new PartListEntry("B Part", 12);
        
        int expResult = 1;
        int result = second.compareTo(first);
        assertEquals(expResult, result);

        expResult = -1;
        result = first.compareTo(second);
        assertEquals(expResult, result);

        expResult = 0;
        result = first.compareTo(first);
        assertEquals(expResult, result);
    }
}
