package api;

import java.io.IOException;

import lsp.LostConectionException;

public interface LspClientInterface {
	/**
	 * Devolve o Id da conexo
	 */
	public short getConnId();

	/**
	 * Devolve um vetor de bytes de uma mensagem enviada pelo lado servidor .
	 * Devolve null se a conexo for perdida .
	 */
	public byte[] read();

	/**
	 * Envia uma mensagen para o lado servidor como um vetor de bytes . Devolve
	 * exceo se a conexo for perdida .
	 * @throws IOException 
	 */
	public void write(byte[] payload) throws IOException;

	/**
	 * Encerra a conexo .
	 */
	public void close();

}
