package api;

import java.io.IOException;

import lsp.Pack;

public interface LspServerInterface {
	/**
	 * L dados da fila de entrada do servidor . Se no houver dados recebidos,
	 * bloqueia o chamador at que dados sejam recebidos . Os dados esto
	 * encapsulados pela classe Pack.
	 */
	public Pack read();

	/**
	 * Envia dados para um determinado cliente . Deve Devolver exceo se a
	 * conexo estiver encerrada.
	 * @throws IOException 
	 */
	public void write(Pack pack) throws IOException;

	/**
	 * Encerra uma conexo com o identificador connId.
	 */
	public void closeConn(short connId);

	/**
	 * Encerra todas as conexes dos clientes.
	 */
	public void closeAll();

}
