package edu.hit.ir.HitCirLtp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import org.jdom.Document;
import org.jdom.JDOMException;

import edu.hit.ir.xmlAnalysis.*;
import edu.hit.ir.webcleitapi.*;

public class HitCirLtp {
	private XmlAnalysis xml = new XmlAnalysis();
	private LtpService ltpSer;
//	private String url = "http://192.168.3.134:12345/ltp";
	private String resultStr = null;
	private boolean authorzed = true;
	
	public HitCirLtp(String authorization) {
		super();
		ltpSer = new LtpService(authorization);
	}
	
	//
	/**
	 * <p>Title: toAnalyzeStr</p>
	 * <p>Description:
	 * 		analyse the string, and this has to be done after the set activities. 
	 * </p>
	 * @param rawStuff
	 * @return the raw string is analysed successfully or not
	 */
	public boolean toAnalyzeStr(String rawStuff){
		try {/*
			System.out.println(rawStuff + "\t" + rawStuff.length());
			rawStuff =  removeEnter(rawStuff);
			
			System.out.println(rawStuff + "\t" + rawStuff.length());
			//*/
			resultStr = ltpSer.Connect(rawStuff);
//			System.out.println(resultStr);
			
			xml.build(resultStr);
		} catch (JDOMException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
		return true;
	}
	/**
	 * <p>Title: toAnalyzeFile</p>
	 * <p>Description: 
	 * 		analyse the file, and this has to be done after the set activities. 
	 * </p>
	 * @param filename
	 * @return the file is analysed successfully or not
	 */
	public boolean toAnalyzeFile(String filename){
		String rawStuff = "";
		try {
			File in = new File(filename);
			
			char[] cBuf = new char[1024];
			BufferedReader br = new BufferedReader(new InputStreamReader(
					new FileInputStream(in)));

			int rs;
			while(( rs = br.read(cBuf)) != -1){
				rawStuff += new String(cBuf, 0, rs);
			}
			br.close();
//			System.out.println(rawStuff);
		} catch (FileNotFoundException ex) {
			ex.printStackTrace();
			return false;
		} catch (IOException ex) {
			ex.printStackTrace();
			return false;
		}
		return toAnalyzeStr(rawStuff);
		
	}
	
	public boolean toDependencyParser(DependencyDoc dc){
		setDependencyParser();
		toAnalyzeStr(dc.toString());
		return true;
	}

	public String removeEnter(String str){
		if( str == null ||str.length()==0)
			return "";
		for(int i= 0; i<str.length(); ++i){
			if(str.getBytes()[i] == '\r' || str.getBytes()[i] == '\n'){
				return str.substring(0, i) + removeEnter(str.substring(i+1, str.length()));
			}
		}
		return str;
	}
	/**
	 * <p>Title: setEncoding</p>
	 * <p>Description: 
	 * 		set the encoding type.
	 * 		the type is defined in Data.java, including Data.GB2312 and Data.UTF8
	 * </p>
	 * @param encodeType
	 * @return
	 */
	public boolean setEncoding(String encodeType){
		return ltpSer.setEncoding(encodeType);
	}
	public void setAuthorization(String authorization){
		ltpSer.setAuthorization(authorization);
	}
	public boolean isAuthorzed(){
		return authorzed;
	}
	public void setAnalysisOption(int op){
		ltpSer.setAnalysisOptions(op);
	}
	public void setAnalysisAll(){
		ltpSer.setAnalysisAll();
	}
	
	public String getResultStr(){
		return resultStr;
	}
		
	public void setDependencyParser() {
		ltpSer.setDependencyParser();
	}

	//XML
	public boolean isWs(){
		return xml.isWs();
	}
	public boolean isDp() {
		return xml.isDp();
	}

	public boolean isNer() {
		return xml.isNer();
	}

	public boolean isPos() {
		return xml.isPos();
	}

	public boolean isSrl() {
		return xml.isSrl();
	}
	public boolean isWsd(){
		return xml.isWsd();
	}
	//xml information
	/**
	 * <p>Title: CountParagraphInDocument</p>
	 * @return the number of paragraphs in the document;
	 */
	public int CountParagraphInDocument() {
		return xml.CountParagraphInDocument();
	}

	/**
	 * <p>Title: CountSentenceInDocument</p>
	 * @return the number of sentences in the whole document;
	 */
	public int CountSentenceInDocument() {
		return xml.CountSentenceInDocument();
	}

	/**
	 * <p>Title: CountSentenceInParagraph</p>
	 * @param paragraphIdx
	 * @return the number of sentences in a special paragraph
	 */
	public int CountSentenceInParagraph(int paragraphIdx) {
		return xml.CountSentenceInParagraph(paragraphIdx);
	}

	/**
	 * <p>Title: CountWordInDocument</p>
	 * @return the word number in the whole document;
	 */
	public int CountWordInDocument() {
		return xml.CountWordInDocument();
	}

	/**
	 * <p>Title: CountWordInParagraph</p>
	 * <p>Description: </p>
	 * @param paragraphIdx
	 * @return the word number in a special paragraph;
	 */
	public int CountWordInParagraph(int paragraphIdx) {
		return xml.CountWordInParagraph(paragraphIdx);
	}

	/**
	 * <p>Title: CountWordInSentence</p>
	 * <p>Description: 
	 * 		according to the index of paragraph and sentence;
	 * </p>
	 * @param paragraphIdx
	 * @param sentenceIdx
	 * @return the word number in a special sentence;
	 */
	public int CountWordInSentence(int paragraphIdx, int sentenceIdx) {
		return xml.CountWordInSentence(paragraphIdx, sentenceIdx);
	}

	/**
	 * <p>Title: CountWordInSentence</p>
	 * <p>Description: 
	 * 		according to the index of global sentence id;
	 * </p>
	 * @param globalSentIdx
	 * @return the word number in a special sentence;
	 */
	public int CountWordInSentence(int globalSentIdx) {
		return xml.CountWordInSentence(globalSentIdx);
	}

	/**
	 * <p>Title: getWord</p>
	 * <p>Description: 
	 * 		according to the index of paragraph, sentence and word;
	 * </p>
	 * @param paragraphId
	 * @param sentenceId
	 * @param wordId
	 * @return get the type of Word;
	 */
	public Word getWord(int paragraphId, int sentenceId, int wordId) {
		return xml.getWord(paragraphId, sentenceId, wordId);
	}

	/**
	 * <p>Title: getWord</p>
	 * <p>Description: 
	 * 		according to the index of global word id;
	 * 		this method is not advocated;
	 * </p>
	 * @param globalWordId
	 * @return get the type of Word;
	 */
	public Word getWord(int globalWordId) {
		return xml.getWord(globalWordId);
	}

	/**
	 * <p>Title: getWords</p>
	 * <p>Description: 
	 * 		according to the index of paragraph and sentence;
	 * </p>
	 * @param paragraphId
	 * @param sentenceId
	 * @return Word List;
	 */
	public List<Word> getWords(int paragraphId, int sentenceId) {
		return xml.getWords(paragraphId, sentenceId);
	}

	/**
	 * <p>Title: getWordsFromSentence</p>
	 * <p>Description: 
	 * 		according to the index of global sentence id;
	 * </p>
	 * @param globalSentenceId
	 * @return	Word List;
	 */
	public List<Word> getWordsFromSentence(int globalSentenceId) {
		return xml.getWordsFromSentence(globalSentenceId);
	}
	
	/**
	 * <p>Title: getSentenceContent</p>
	 * <p>Description: 
	 * 		according to the index of paragraph and sentence;
	 * </p>
	 * @param paragraphIdx
	 * @param sentenceIdx
	 * @return the content of a sentence;
	 */
	public String getSentenceContent(int paragraphIdx, int sentenceIdx) {
		return xml.getSentenceContent(paragraphIdx, sentenceIdx);
	}

	/**
	 * <p>Title: getSentenceContent</p>
	 * <p>Description: 
	 * 		according to the index of global sentence id;
	 * </p>
	 * @param globalSentIdx
	 * @return the content of a sentence; 
	 */
	public String getSentenceContent(int globalSentIdx) {
		return xml.getSentenceContent(globalSentIdx);
	}

	/**
	 * <p>Title: SaveDom</p>
	 * <p>Description: 
	 * 		save the dom tree into a file;
	 * </p>
	 * @param filename
	 */
	public void SaveDom(String filename) {
		xml.SaveDom(filename);
	}	
	/**
	 * <p>Title: getDom</p>
	 * <p>Description: 
	 * 		get the dom tree;
	 * </p>
	 * @return 
	 */
	public Document getDom(){
		return xml.getDom();
	}
}
