package edu.hit.ir.junitTest;

import java.util.List;

import edu.hit.ir.HitCirLtp.HitCirLtp;
import edu.hit.ir.xmlAnalysis.Data;
import edu.hit.ir.xmlAnalysis.Word;
import edu.hit.ir.xmlAnalysis.Srl;
import edu.hit.ir.xmlAnalysis.DependencySent;
import edu.hit.ir.xmlAnalysis.DependencyDoc;

public class Ltp_example4 {
	public static void main(String[] args){
		HitCirLtp ltp = new HitCirLtp("zhhan@ir.hit.edu.cn");

		if(!ltp.isAuthorzed()){
			System.out.println("֤ϢĿǰ߱κ");
			return;
		}
		ltp.setAnalysisOption(Data.DP);
		DependencyDoc dc = new DependencyDoc();
		DependencySent dd = new DependencySent();
		dd.add("", "r");
		dd.add("", "v");
		dd.add("", "ns");
		dd.add("찲", "ns");
		dd.add("", "wp");
		dc.add(dd);

		DependencySent dd2 = new DependencySent();
		dd2.add("", "r");
		dd2.add("", "v");
		dd2.add("", "ns");
		dd2.add("찲", "ns");
		dd2.add("", "wp");
		dc.add(dd);
		
		System.out.println(dc.toString());
		
//		ltp.setEncoding(Data.GB2312);
		ltp.toDependencyParser(dc);
		/*
		System.out.println(""+ltp.isWs()
				+ "\t" + ltp.isPos()
				+ "\t" + ltp.isNer()
				+ "\t" + ltp.isWsd()
				+ "\t" + ltp.isDp()
				+ "\t" + ltp.isSrl()
				);
				//*/
		int paraNum = ltp.CountParagraphInDocument();
		for(int i = 0; i<paraNum; ++i){
			int sentNum = ltp.CountSentenceInParagraph(i);
			for(int j = 0; j<sentNum; ++j){
				int wordNum= ltp.CountWordInSentence(i, j);
				for(int p = 0; p<wordNum; ++p){
					Word wd = ltp.getWord(i, j, p);
					if(ltp.isWs()){
						System.out.print(wd.getContent());
					}
					if(ltp.isPos()){
						System.out.print("\t" + wd.getPos());
					}
					if(ltp.isNer()){
						System.out.print("\t" + wd.getNe());
					}
					if(ltp.isDp()){
						System.out.print("\t" + wd.getParseParent() + " - " + wd.getParseRelation());						
					}
					if(ltp.isWsd()){
						System.out.print("\t" + wd.getWsd() +" - " +wd.getWsdExplanation());
					}
					if(ltp.isSrl()&&wd.hasSrl()){
						List<Srl> srls = wd.getSrls();
						System.out.println();
						for(int q = 0; q<srls.size(); q++){
							System.out.println("\t" + srls.get(q).type + "\t" + srls.get(q).beg + " - " + srls.get(q).end);
						}
					}
					System.out.println();
				}
			}
		}
	}
}