package edu.hit.ir.junitTest;

import junit.framework.TestCase;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

import org.jdom.JDOMException;

import edu.hit.ir.webcleitapi.WebCleintAPI;
import edu.hit.ir.xmlAnalysis.Word;
import edu.hit.ir.xmlAnalysis.XmlAnalysis;

public class XmlAnalyzeCase extends TestCase {
	XmlAnalysis xml;

	protected void setUp() throws Exception {
		xml = new XmlAnalysis();
		/*
		 * HashMap<String, String> parMap = new HashMap<String, String>();
		 * parMap.put("s", "2009ܽڹٰݳᣬݳᳪһס໨ɡǳ"); String
		 * here = WebCleintAPI.doPost("http://192.168.3.134:12345/ltp", parMap,
		 * "GB2312"); //
		 */
		xml.build(new File("ltp.xml"));
		// System.out.println("hello:"+ xml.isWs());
		// xml.outputters();
	}

	protected void tearDown() throws Exception {
		;
	}

	public void testAdd() {
		// boolean is = ;
		assertEquals(true, xml.isWs());
		assertEquals(true, xml.isPos());
		assertEquals(true, xml.isNer());
		assertEquals(true, xml.isWsd());
		assertEquals(true, xml.isDp());
		assertEquals(true, xml.isSrl());
		// xml.SaveDom("myltp.xml");

		assertEquals(1, xml.CountParagraphInDocument());
		assertEquals(4, xml.CountSentenceInParagraph(0));
		assertEquals(91, xml.CountWordInDocument());
		assertEquals(4, xml.CountSentenceInDocument());
		assertEquals(91, xml.CountWordInParagraph(0));
		assertEquals(29, xml.CountWordInSentence(3));
		assertEquals(29, xml.CountWordInSentence(0, 3));
		/*
		 * assertEquals("O",
		 * xml.getParagraph(0).getSentence(1).getWord(2).getNe());
		 * assertEquals("",
		 * xml.getParagraph(0).getSentence(3).getWord(28).getWord()); //
		 */
		List<Word> wordList = xml.getWords(0, 0);
		assertEquals("p", xml.getWord(0, 0, 2).getPos());
		assertNotNull(wordList);
		assertNotNull(wordList.get(2));
		assertEquals("p", xml.getWords(0, 0).get(2).getPos());
		assertEquals("Ͼ", xml.getWords(0, 2).get(4).getContent());
		assertEquals("Ka23", xml.getWord(0, 2, 25).getWsd());
		assertEquals("ͬ_ͷ___", xml.getWord(0, 2, 25)
				.getWsdExplanation());
		assertFalse(xml.getWord(0, 2, 25).hasSrl());
		assertTrue(xml.getWord(0, 2, 26).hasSrl());
		assertEquals("AM-ADV", xml.getWords(0, 3).get(23).getSrls().get(0).type);
		assertEquals(22, xml.getWords(0, 3).get(23).getSrls().get(0).beg);
		assertEquals(22, xml.getWords(0, 3).get(23).getSrls().get(0).end);
		assertEquals("", xml.getWordsFromSentence(3).get(8).getContent());
		assertEquals("", xml.getWord(33).getContent());
		assertEquals("ⲿΪϾ--ѵļ䡷ļ¼Ƭɵ׺һݵĴСѧʦͬ"
				, xml.getSentenceContent(0, 2));
		assertEquals("ӰƬ¼13ϾɱľʵսеĽйˣҲвսձ"
				, xml.getSentenceContent(3));
	}

}
