/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * TestFrame.java
 *
 * Created on 28-jul-2011, 12:52:01
 */
package com.infinityk.simplesoundengine.test;

import com.infinityk.simplesoundengine.Log;
import com.infinityk.simplesoundengine.LogSystem;
import com.infinityk.simplesoundengine.SimpleSoundEngine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Asier
 */
class TestFrame extends javax.swing.JFrame implements LogSystem{
    private final GenericListModel<SoundFileEntry> musics;
    private final GenericListModel<SoundFileEntry> sounds;
    private final SimpleSoundEngine soundEngine;
    private final PollWorker pollWorker;
    
    /** Creates new form TestFrame */
    public TestFrame() {
        musics = new GenericListModel<SoundFileEntry>();
        sounds = new GenericListModel<SoundFileEntry>();
        initComponents();
        ListFileDrop.addDroper(musicList, musics);
        ListFileDrop.addDroper(soundList, sounds);
        Log.setLogSystem(this);
        soundEngine = new SimpleSoundEngine();
        soundEngine.init();
        pollWorker = new PollWorker(soundEngine);
        pollWorker.start();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        musicList = new javax.swing.JList();
        playMusicButton = new javax.swing.JButton();
        loopedCheckbox = new javax.swing.JCheckBox();
        delMusicButton = new javax.swing.JButton();
        pauseMusicButton = new javax.swing.JButton();
        unpauseMusicButton = new javax.swing.JButton();
        stopMusicButton = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        soundList = new javax.swing.JList();
        unloadButton = new javax.swing.JButton();
        unloadAllButton = new javax.swing.JButton();
        stopAllButton = new javax.swing.JButton();
        loadSoundButton = new javax.swing.JButton();
        gainSpinner = new javax.swing.JSpinner();
        pitchSpinner = new javax.swing.JSpinner();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        playSoundButton = new javax.swing.JButton();
        playESoundButton = new javax.swing.JButton();
        delSoundButton = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        logArea = new javax.swing.JTextArea();
        jButton1 = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("InfinityK SimpleSoundEngine");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Music"));

        musicList.setModel(musics);
        jScrollPane2.setViewportView(musicList);

        playMusicButton.setText("Play");
        playMusicButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                playMusicButtonActionPerformed(evt);
            }
        });

        loopedCheckbox.setText("Looped");

        delMusicButton.setText("Del");
        delMusicButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                delMusicButtonActionPerformed(evt);
            }
        });

        pauseMusicButton.setText("Pause");
        pauseMusicButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pauseMusicButtonActionPerformed(evt);
            }
        });

        unpauseMusicButton.setText("Unpause");
        unpauseMusicButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                unpauseMusicButtonActionPerformed(evt);
            }
        });

        stopMusicButton.setText("Stop");
        stopMusicButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopMusicButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(playMusicButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(stopMusicButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(pauseMusicButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(loopedCheckbox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(delMusicButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(unpauseMusicButton))
                .addContainerGap())
            .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 174, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 97, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(playMusicButton)
                    .addComponent(loopedCheckbox))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(pauseMusicButton)
                    .addComponent(unpauseMusicButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(stopMusicButton)
                    .addComponent(delMusicButton)))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Sounds"));

        soundList.setModel(sounds);
        jScrollPane3.setViewportView(soundList);

        unloadButton.setText("unload");
        unloadButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                unloadButtonActionPerformed(evt);
            }
        });

        unloadAllButton.setText("unload all");
        unloadAllButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                unloadAllButtonActionPerformed(evt);
            }
        });

        stopAllButton.setText("Stop all");
        stopAllButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopAllButtonActionPerformed(evt);
            }
        });

        loadSoundButton.setText("load");
        loadSoundButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadSoundButtonActionPerformed(evt);
            }
        });

        gainSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.0f), null, Float.valueOf(0.1f)));

        pitchSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.0f), null, Float.valueOf(0.1f)));

        jLabel1.setText("Gain:");

        jLabel2.setText("Pitch");

        playSoundButton.setText("Play");
        playSoundButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                playSoundButtonActionPerformed(evt);
            }
        });

        playESoundButton.setText("PlayE");
        playESoundButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                playESoundButtonActionPerformed(evt);
            }
        });

        delSoundButton.setText("Del");
        delSoundButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                delSoundButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(playSoundButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(playESoundButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(loadSoundButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(delSoundButton, javax.swing.GroupLayout.DEFAULT_SIZE, 73, Short.MAX_VALUE))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 39, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(gainSpinner, javax.swing.GroupLayout.DEFAULT_SIZE, 83, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup()
                        .addComponent(unloadButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(unloadAllButton)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(pitchSpinner, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 90, Short.MAX_VALUE)
                    .addComponent(stopAllButton, javax.swing.GroupLayout.DEFAULT_SIZE, 90, Short.MAX_VALUE)))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addGap(10, 10, 10)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 252, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 102, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(playSoundButton)
                    .addComponent(playESoundButton)
                    .addComponent(loadSoundButton)
                    .addComponent(delSoundButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(gainSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2)
                    .addComponent(pitchSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(unloadButton)
                    .addComponent(unloadAllButton)
                    .addComponent(stopAllButton)))
        );

        logArea.setColumns(20);
        logArea.setEditable(false);
        logArea.setRows(5);
        jScrollPane1.setViewportView(logArea);

        jButton1.setText("Clear");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 411, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton1)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jButton1)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        soundEngine.destroy();
        System.exit(0);
    }//GEN-LAST:event_formWindowClosing

    
    private void playMusicButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playMusicButtonActionPerformed
        int index = musicList.getSelectedIndex();
        if(index != -1){
            String path = musics.getAt(index).getPath();
            boolean looped = loopedCheckbox.isSelected();
            try {
                soundEngine.playMusic(path, looped);
            } catch (IOException ex) {
                error("Playing music", ex);
                Logger.getLogger(TestFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }//GEN-LAST:event_playMusicButtonActionPerformed

    private void pauseMusicButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pauseMusicButtonActionPerformed
        soundEngine.pauseMusic(true);
    }//GEN-LAST:event_pauseMusicButtonActionPerformed

    private void unpauseMusicButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_unpauseMusicButtonActionPerformed
        soundEngine.pauseMusic(false);
    }//GEN-LAST:event_unpauseMusicButtonActionPerformed

    private void stopMusicButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopMusicButtonActionPerformed
        soundEngine.stopMusic();
    }//GEN-LAST:event_stopMusicButtonActionPerformed

    private void delMusicButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_delMusicButtonActionPerformed
       int[] selectedIndices = musicList.getSelectedIndices();
       musics.delete(selectedIndices);
    }//GEN-LAST:event_delMusicButtonActionPerformed

    private List<String> getSelectedSounds(){
        ArrayList<String> toReturn = new ArrayList<String>();
        int[] indices = soundList.getSelectedIndices();
        for(int i : indices){
            toReturn.add( sounds.getAt(i).getPath() );
        }
        return toReturn;
    }
    
    private void playSoundButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playSoundButtonActionPerformed
        List<String> paths = getSelectedSounds();
        for(String s : paths){
            soundEngine.playSound(s);
        }
    }//GEN-LAST:event_playSoundButtonActionPerformed

    private void playESoundButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playESoundButtonActionPerformed
        List<String> paths = getSelectedSounds();
        float gain = ((Float)gainSpinner.getValue());
        float pitch = ((Float)pitchSpinner.getValue());
        for(String s : paths){
            soundEngine.playSoundE(s, gain, pitch);
        }
    }//GEN-LAST:event_playESoundButtonActionPerformed

    private void loadSoundButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadSoundButtonActionPerformed
        List<String> paths = getSelectedSounds();
        for(String s : paths){
            soundEngine.loadSound(s);
        }
    }//GEN-LAST:event_loadSoundButtonActionPerformed

    private void delSoundButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_delSoundButtonActionPerformed
        int[] indices = soundList.getSelectedIndices();
        sounds.delete(indices);
    }//GEN-LAST:event_delSoundButtonActionPerformed

    private void unloadButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_unloadButtonActionPerformed
        List<String> paths = getSelectedSounds();
        for(String s : paths){
            soundEngine.unloadSound(s);
        }
    }//GEN-LAST:event_unloadButtonActionPerformed

    private void unloadAllButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_unloadAllButtonActionPerformed
        soundEngine.unloadAllSounds();
    }//GEN-LAST:event_unloadAllButtonActionPerformed

    private void stopAllButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopAllButtonActionPerformed
        soundEngine.stopAllSounds();
    }//GEN-LAST:event_stopAllButtonActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        logArea.setText("");
    }//GEN-LAST:event_jButton1ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton delMusicButton;
    private javax.swing.JButton delSoundButton;
    private javax.swing.JSpinner gainSpinner;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JButton loadSoundButton;
    private javax.swing.JTextArea logArea;
    private javax.swing.JCheckBox loopedCheckbox;
    private javax.swing.JList musicList;
    private javax.swing.JButton pauseMusicButton;
    private javax.swing.JSpinner pitchSpinner;
    private javax.swing.JButton playESoundButton;
    private javax.swing.JButton playMusicButton;
    private javax.swing.JButton playSoundButton;
    private javax.swing.JList soundList;
    private javax.swing.JButton stopAllButton;
    private javax.swing.JButton stopMusicButton;
    private javax.swing.JButton unloadAllButton;
    private javax.swing.JButton unloadButton;
    private javax.swing.JButton unpauseMusicButton;
    // End of variables declaration//GEN-END:variables

    @Override
    public void info(String s) {
        logArea.append("INFO - " + s + "\n");
    }

    @Override
    public void warn(String s) {
        logArea.append("WARNNING - " + s + "\n");
    }

    @Override
    public void error(String s) {
        logArea.append("ERROR - " + s + "\n");
    }

    @Override
    public void error(Exception s) {
        logArea.append("ERROR - " + s + "\n");
    }

    @Override
    public void error(String s, Exception e) {
        logArea.append("ERROR - " + s + " - " + e + "\n");
    }
}
