package agent;

import java.util.Vector;

import com.Event;

/**
 * The Proxy was developed to avoid the loss of events sent to an Agent in migration status. 
 * While the Agent migrates, it can't accept events. The proxy saves every event and at the end of the migration
 * the ExecutionEngine sends these events to the destination node. After the migration if some events arrives at 
 * proxy node, the ExecutionEngine forwards the event to the address saved in the proxy.
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public interface IAgentProxy {
	
	/**
	 * Getter of the property <tt>agentID</tt>
	 * 
	 * @return Returns the Agent ID
	 */
	public String 	getAgentID();
	
	/**
	 * Getter of the property <tt>agentAddress</tt>
	 * 
	 * @return Returns the Agent Address
	 */
	public String 	getAgentAddress();

	/**
	 * Adds an event to the Events Queue
	 * @param event Event to add
	 */
	public void 	addEvent(Event event);
	
	/**
	 * Getter of the property <tt>events</tt>
	 * 
	 * @return Returns the Events Queue
	 */
	public Vector	getEvents();
	
	/**
	 * Clears the Events Queue after a successful migration
	 */
	public void  	clearEvents();
	
	/**
	 * Check the Events Queue to tell if the migration is executed or not. If
	 * the queue is null the migration is executed
	 * @return Returns if the migration is executed or not
	 */
	public boolean  isMigrationExecuted();
	
}