package agent;

import com.Event;

/**
 * The plane is an abstract class for a behavior of the Agent. The inherited class must implement the "eventHandler"
 * method. This method receives an event and contains the plane's automata, which represents the dynamic 
 * behavior of the MA in this plane and is composed of states and mutually exclusive transitions among states.
 * Transitions are labeled by ECA rules: E[C]/A, where E is the event name, [C] is a boolean expression based on 
 * private parameters and A is the atomic action which can use Agent's functions to perform computations
 * 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public abstract class Plane {
	
	
	/**
	 * Plane's Agent
	 */
	protected Agent agent;
	
	/**
	 * Current state of the automata
	 */
	protected byte currentState;	
	
	/**
	 * The Constructor needs only the reference to the Mobile Agent
	 * @param agent Mobile Agent that contains the plane
	 */
	public Plane (Agent agent)
	{
		this.agent	= agent;
	}
	
	/**
	 * Getter of the property <tt>agent</tt>
	 * 
	 * @return Returns the agent.
	 */
	public Agent getAgent() {
		return agent;
	}
		
	/**
	 * The Automata of the current Plane
	 */
	public abstract void eventHandler(Event event);
	
}
