package requestEnvelopes.server;

import com.Event;
import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;
import com.sun.spot.interisolate.VoidReplyEnvelope;

import server.interfaces.IMobileAgentExecutionEngine;

/**
 * This class allows the Agent to invoke Execution Engine's actuate method.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class Actuate extends RequestEnvelope{

	private String sourceMA;
	private Event backEvent;
	
	public Actuate (String sourceMA, Event backEvent) {
		this.sourceMA = sourceMA;
		this.backEvent = backEvent;
	}
	
	public ReplyEnvelope execute(Object context){
		((IMobileAgentExecutionEngine)context).actuate(this.sourceMA, this.backEvent);
		return new VoidReplyEnvelope(getUid());
	}

}
