package requestEnvelopes.server;

import server.interfaces.IMobileAgentExecutionEngine;

import com.sun.spot.interisolate.ObjectReplyEnvelope;
import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;

/**
 * This class allows the Agent to invoke Execution Engine's create method.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class Create extends RequestEnvelope{

	private String agentID = "";
	private String sourceMA;
	private String agent;
	private String [] params;
	private String nodeID;
	
	public Create (String sourceMA, String agent, String [] params, String nodeID){
		this.sourceMA = sourceMA;
		this.agent = agent;
		this.params = params;
		this.nodeID = nodeID;
	}
	
	public Create (String agentID, String sourceMA, String agent, String [] params, String nodeID){
		this.agentID = agentID;
		this.sourceMA = sourceMA;
		this.agent = agent;
		this.params = params;
		this.nodeID = nodeID;
	}
	
	public ReplyEnvelope execute(Object context){
		if (agentID.equals("")) {
			boolean created = ((IMobileAgentExecutionEngine)context).create(this.sourceMA, this.agent, this.params, this.nodeID);
			return new ObjectReplyEnvelope(getUid(), new Boolean(created));
		}
		else {
			boolean created = ((IMobileAgentExecutionEngine)context).create(this.agentID, this.sourceMA, this.agent, this.params, this.nodeID);
			return new ObjectReplyEnvelope(getUid(), new Boolean(created));
		}
		
	}

}
