package requestEnvelopes.server;

import java.util.Vector;

import com.sun.spot.interisolate.ObjectReplyEnvelope;
import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;

import server.interfaces.IMobileAgentExecutionEngine;

/**
 * This class allows the Agent to invoke Execution Engine's getNeighbors method.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class GetNeighbors extends RequestEnvelope{
	
	public ReplyEnvelope execute(Object context){
		Vector neighbors = ((IMobileAgentExecutionEngine)context).getNeighbors();
		return new ObjectReplyEnvelope(getUid(), neighbors);
	}

}
