package requestEnvelopes.server;

import com.Event;
import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;
import com.sun.spot.interisolate.VoidReplyEnvelope;

import server.interfaces.IMobileAgentExecutionEngine;

/**
 * This class allows the Agent to invoke Execution Engine's send method.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class Send extends RequestEnvelope{

	private String sourceMA;
	private String targetMA;
	private Event message;
	private boolean local;
	
	public Send (String sourceMA, String targetMA,  Event message, boolean local){
		this.sourceMA = sourceMA;
		this.targetMA = targetMA;
		this.message = message;
		this.local = local;
	}
	
	public ReplyEnvelope execute(Object context){
		((IMobileAgentExecutionEngine)context).send(sourceMA, targetMA, message, local);
		return new VoidReplyEnvelope(getUid());
	}

}
