package requestEnvelopes.server;

import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;
import com.sun.spot.interisolate.VoidReplyEnvelope;

import server.interfaces.IMobileAgentExecutionEngine;

/**
 * This class allows the Agent to invoke Execution Engine's startAgent method.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class StartAgent extends RequestEnvelope{

	private String agentName;
	
	public StartAgent (String agentName){
		this.agentName = agentName;
	}
	
	public ReplyEnvelope execute(Object context){
		((IMobileAgentExecutionEngine)context).startAgent(agentName);
		return new VoidReplyEnvelope(getUid());
	}

}
