package sensorBoard.io;

import sensorBoard.ISensorBoardComponent;
import server.interfaces.ISensorBoardManager;

import com.Event;
import com.LedsManager;
import com.ParamNotFoundException;
import com.ParamsLabel;
import com.sun.spot.resources.transducers.LEDColor;

/**
 * LedOut manages the access to the node LEDs. It's possible to turn ON or OFF and to blink a LED specifying a color
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class LedOut implements ISensorBoardComponent {
	
	private byte [] handlableEvents = {Event.LED_ON, 
			Event.LED_OFF, 
			Event.LED_BLINK};
	
	private ISensorBoardManager sensorBoardManager;
	
	/**
	 * The constructor needs to know own ioManager, the access to LED resource is realized thanks to LEDManager utility class 
	 * @param sensorBoardManager its own manager
	 */
	public LedOut (ISensorBoardManager sensorBoardManager) {
		this.sensorBoardManager = sensorBoardManager;
	}
	
	public boolean IsEventHandlable(byte eventName) {
		for (int i = 0; i < handlableEvents.length; i++) 
			if (this.handlableEvents[i] == eventName)
				return true;
		return false;
	}
	
	public void handleEvent(Event event) {
		
		
		try {
			byte eventName = event.getName();
			switch (eventName) {
				case Event.LED_ON:
					if (event.getType() == Event.NOW) {
						LEDColor color = this.getColor(event.getParam(ParamsLabel.LED_COLOR));
						int index = Integer.parseInt(event.getParam("index"));
						if (index >= 0 && index <= 6 && color!=null);
							LedsManager.ledON(index, color);
					}
				break;
				case Event.LED_OFF:
					if (event.getType() == Event.NOW) {
						int index = Integer.parseInt(event.getParam(ParamsLabel.LED_INDEX));
						if (index >= 0 && index <= 6);
							LedsManager.ledOFF(index);
					}
				break;
				case Event.LED_BLINK:
					if (event.getType() == Event.NOW) {
						LEDColor color = this.getColor(event.getParam(ParamsLabel.LED_COLOR));
						int index = Integer.parseInt(event.getParam(ParamsLabel.LED_INDEX));
						if (index >= 0 && index <= 6 && color!=null);
							LedsManager.blink(index, color);
					}
				break;
			}
		}
		catch (NumberFormatException e) {
			LedsManager.error(LEDColor.YELLOW);
			e.printStackTrace();
		}
		catch (ParamNotFoundException e) {
			LedsManager.error(LEDColor.YELLOW);
			e.printStackTrace();
		}
		
	}
	
	public void send(Event backEvent) {
		this.sensorBoardManager.send(backEvent);
	}
	
	public boolean terminateListener(String sensorBoardComponentID) {
		return false;
	}
	
	/**
	 * Converts a string in a LEDColor object.
	 * The possible strings are: BLUE, CHARTREUSE, CYAN, GREEN, MAGENTA, MAUVE, ORANGE, PUCE, TURQUOISE, WHITE, YELLOW
	 * If the string doesn't exist the function returns null.
	 * @param color the string that specifies the color
	 * @return LEDColor object if the color is found, "null" otherwise
	 */
	public LEDColor getColor (String color) {
		
		if (color.equalsIgnoreCase("BLUE"))
			return LEDColor.BLUE;
		if (color.equalsIgnoreCase("CHARTREUSE"))
			return LEDColor.CHARTREUSE;
		if (color.equalsIgnoreCase("CYAN"))
			return LEDColor.CYAN;
		if (color.equalsIgnoreCase("GREEN"))
			return LEDColor.GREEN;
		if (color.equalsIgnoreCase("MAGENTA"))
			return LEDColor.MAGENTA;
		if (color.equalsIgnoreCase("MAUVE"))
			return LEDColor.MAUVE;
		if (color.equalsIgnoreCase("ORANGE"))
			return LEDColor.ORANGE;
		if (color.equalsIgnoreCase("PUCE"))
			return LEDColor.PUCE;
		if (color.equalsIgnoreCase("RED"))
			return LEDColor.RED;
		if (color.equalsIgnoreCase("TURQUOISE"))
			return LEDColor.TURQUOISE;
		if (color.equalsIgnoreCase("WHITE"))
			return LEDColor.WHITE;
		if (color.equalsIgnoreCase("YELLOW"))
			return LEDColor.YELLOW;
		return null;
	}
	
}


