package server;

import java.util.Vector;

import server.interfaces.IMobileAgentExecutionEngine;
import server.interfaces.IMobileAgentNaming;

public class MobileAgentNaming implements IMobileAgentNaming {
	
	/**
	 * Spot Address
	 */
	private Vector address;
	/**
	 * Spot's agents  
	 */
	private Vector agents;
	
	/**
	 * Creates a MobileAgentNaming 
	 * @param executionEngine the component IMobileAgentExecutionEngine
	 */
	public MobileAgentNaming (IMobileAgentExecutionEngine executionEngine) {
		this.address = new Vector();
		this.agents = new Vector();
	}
	
	public String getAddress(String agentID) {
		int spotIndex = this.indexOfSpotByAgent(agentID);
		if (spotIndex!=-1)
			return (String)address.elementAt(spotIndex);
		else
			return "";
	}
	
	public Vector getNeighborsAddress() {
		return this.address;
	}
	
	public Vector getNeighborsAgents() {
		Vector neighborsAgents = new Vector();
		
		for (int i = 0; i < agents.size(); i++) {
			Vector agentNames = (Vector)agents.elementAt(i);
			for (int j = 0; j < agentNames.size(); j++)		
				neighborsAgents.addElement(agentNames.elementAt(j));
		}
		return neighborsAgents;
	}
	
	public Vector getSpotAgents(String spotAddress) {
		int spotIndex = indexOfSpotByAddress(spotAddress);
		if (spotIndex!=-1)
			return (Vector)agents.elementAt(spotIndex);
		else
			return null;
	}

	public void addSpotAgents(String spotAddress, Vector newAgents) {
		
		if (newAgents.size() == 1)
			this.removeAgent((String)newAgents.elementAt(0));
		
		int spotIndex = indexOfSpotByAddress(spotAddress);
		
		/*
		 * Si suppone che gli spot si conoscano dalla nascita
		 * Non pu pubblicarsi uno Spot che contiene pi di un agente
		 */
		if (spotIndex == -1) {
			this.address.addElement(spotAddress);			
			this.agents.addElement(newAgents);
		}
		else {
			if (newAgents.size() == 0)
				((Vector)this.agents.elementAt(spotIndex)).removeAllElements();
			else
				((Vector)this.agents.elementAt(spotIndex)).addElement((String)newAgents.elementAt(0));
		}
		
	}
	
	/**
	 * Removes an agent
	 * @param agentID
	 */
	private void removeAgent (String agentID) {
		for (int i = 0; i < agents.size(); i++) {
			Vector tempAgents = (Vector)agents.elementAt(i);
			if (tempAgents.removeElement(agentID))
				return;			
		}
	}
	
	/**
	 * Search a node by address
	 * @param spotAddress node address 
	 * @return
	 */
	private int indexOfSpotByAddress (String spotAddress) {
		for (int i = 0; i < address.size(); i++) {
			if ( ((String)address.elementAt(i)).equals(spotAddress) )
				return i;
		}
		return -1;	
	}
	
	/**
	 * Search a node by agent's ID
	 * @param agentID
	 * @return
	 */
	private int indexOfSpotByAgent (String agentID) {
		
		for (int i = 0; i < agents.size(); i++) {
			Vector tempAgents = (Vector)agents.elementAt(i);
			for (int j = 0; j < tempAgents.size(); j++) {
				if ( ((String)tempAgents.elementAt(j)).equals(agentID) )
					return i;
			}
		}
		return -1;		
	}


}
