package server.interfaces;

import java.util.Vector;

import com.Event;

/**
 * 
 * Implemented by class wanting to manage out-coming events and messages to others node.
 * Extends Runnable because it must be a Thread always ready to sends events and manage them. 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public interface IMobileAgentCommunicationChannelSender extends Runnable{
	
	/**
	 * Needs to send just an event
	 * @param event event to send
	 */
	public void send (Event event);
	
	/**
	 * Needs to send a set of events after a successful migration
	 * @param events set of events to send
	 */
	public void send (Vector events);
		
}
