package server.interfaces;

/**
 * Implemented by class wanting to manage incoming and out-coming agents migrations
 * It has got methods to receive migration requests, migration acknowledge, etc.
 * It implements Runnable interface because it must be a thread always ready to accept requests.  
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public interface IMobileAgentMigrationManager extends Runnable {
	
	/**
	 * Adds an agent to migrate in the queue
	 * @param agentName agent's ID to migrate
	 * @param nodeID destination node
	 */
	public  void addAgentToMigrate(String agentName, String nodeID);
	

	/**
	 * invoked when a migration acknowledge message has been received
	 * @param address node address where the agent must be migrated
	 * @param agent agent's ID to migrate
	 */
	public  void migrationAckReceived(String address, String agent);
	
	/**
	 * accepts migration requests from the agents.
	 * @param nodeID node address where the agent wants to migrate
	 * @param agent agent's ID to migrate
	 */
	public void migrationRequest(String nodeID, String agent);
	
}
