package server.interfaces;

import java.util.Vector;

/**
 * Implemented by class wanting to store information about the nodes near the local one.
 * It stores nodes address and the agents working on them  
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public interface IMobileAgentNaming {
	
	/**
	 * Gets the node address where the "agentID" resides
	 * @param agentID agent's ID
	 * @return the node address
	 */
	public String getAddress(String agentID);
	
	/**
	 * Gets the addresses of nodes near to local node
	 * @return the addresses of nodes near to local node
	 */
	public Vector getNeighborsAddress();
	
	/**
	 * Gets agents IDs near to local node
	 * @return agents IDs near to local node
	 */
	public Vector getNeighborsAgents();
	
	/**
	 * Gets the agents of a specific node 
	 * @param spotAddress node's address
	 * @return the agents of a specific node
	 */
	public Vector getSpotAgents(String spotAddress);
	
	/**
	 * Adds a set of agents belong to a specific node
	 * @param spotAddress node's address
	 * @param agents set of agents
	 */
	public void addSpotAgents(String spotAddress, Vector agents);
}
