package server.interfaces;

import sensorBoard.ISensorBoardComponent;

import com.Event;

/**
 * 
 * This interface is needed to the ExecutionEngine for accessing to the sensorBoard resources.
 * Every request from the agents is forwarded by the ExecutionEngine to the ISensorBoardManager objects. 
 * For the access to the sensorBoard, at moment, only two managers exist, one for the sensors resources and 
 * one for the IO resources (SensorManager and IOManager). Every manager has got a set of ISensorBoardComponent.
 * This interface is implemented by classes with direct access to resources, like LightSensor, TemperatureSensor or
 * LedOut.
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public interface ISensorBoardManager extends Runnable{
	
	/**
	 * Adds a ISensorBoardComponent to the Manager
	 * @param sensorBoardComponent ISensorBoardComponent to add
	 */
	public void addResource(ISensorBoardComponent sensorBoardComponent);

	/**
	 * Search the right ISensorBoardComponent for handling the event
	 * @param sourceMA the MobileAgent ID that requires the event handling
	 * @param backEvent the event to send back to the sourceMA
	 */
	public void handleEvent(String sourceMA, Event backEvent);
	
	/**
	 * This method is invoked by the ISensorBoardComponent to send the backEvent to the ExecutionEngine
	 * @param event the event to send
	 */
	public void send(Event event);
	
	/**
	 * This method generate a random ID for a new ISensorBoardComponentListener instance
	 * @return a random numeric ID 
	 */
	public String generateSensorBoardComponentID();
	
}
