package server.interfaces;

import com.Event;

/**
 * Implemented by class wanting to manage timer execution. The TM component provides the
 * timer service which allows to set timers to be used for timing agent operations. It accepts timer requests 
 * and creates the timer with their random ID.
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public interface ITimerManager {
	
	/**
	 * Creates a timer object
	 * @param periodic Specifies if the timer is periodic or is one-shot
	 * @param timeout timeout's length
	 * @param backEvent event to send at expiration time
	 * @return ID of the created timer, generated randomly by generateTimerID() method
	 */
	public String setTimer(boolean periodic, long timeout, Event backEvent);
	
	/**
	 * terminates a timer
	 * @param timerID timer's ID to terminate
	 */
	public void resetTimer(String timerID);
	
	/**
	 * removes a timer 
	 * @param timerID
	 */
	public void removeTimer(String timerID);
	
	/**
	 * generates a random ID for every timer object
	 * @return random ID
	 */
	public String generateTimerID();
	
	/**
	 * Gets the Execution Engine's reference
	 * @return the Execution Engine's reference
	 */
	public IMobileAgentExecutionEngine getExecutionEngine();
	
}
