package ffmpegWrapper;

import java.util.HashMap;
import java.util.Iterator;

import utils.StaticUtils;

public class Parameters {

	private HashMap _paramsMap = new HashMap();
	private String _equation, _delimiter, _preFix;
	
	public Parameters(String equation, String delimiter, String prefix){
		_equation = equation;
		_delimiter = delimiter;
		_preFix = prefix;
	}

	
	public void add(String parameter, String value){ //if exist, override. 
		_paramsMap.put(parameter, value);
	}
	
	public void add(String parameter, Parameters value){ //allows only one hierarchy (because of hardcoded quotes
		_paramsMap.put(parameter, value.toString());
	}
	
	public void add(String key){
		add(key, "");
	}
	
	public void delete(String key){
		_paramsMap.remove(key);
	}
	
	public boolean isExist(String key){
		return _paramsMap.containsKey(key);
	}
	
	public void flush(){
		_paramsMap.clear();
	}
	
	public String toString(){
		
		Iterator<String> keySetIterator = _paramsMap.keySet().iterator();
		StringBuilder line = new StringBuilder();

		while(keySetIterator.hasNext()){
		  String key = keySetIterator.next();
		  line.append(_preFix);
		  line.append(key);
		  if (_paramsMap.get(key) instanceof Parameters){
			  line.append(_equation);
			  line.append(StaticUtils.padWithQuotes(_paramsMap.get(key).toString()));
		  }		  
		  else if (!_paramsMap.get(key).equals("")){ //if not key only
			  line.append(_equation);
			  line.append(_paramsMap.get(key));
		  }	  
		  if (keySetIterator.hasNext())
			  line.append(_delimiter);
		}
		return line.toString();
	}
}
