package gui;


import java.awt.Color;
import java.io.File;
import java.util.Vector;

import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.ImageIcon;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.Font;
import java.awt.Choice;
import javax.swing.JSeparator;

import utils.StaticUtils;
import utils.VideoFile;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JToggleButton;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import java.awt.Cursor;

public class InputClipRow extends JPanel {
	
	
	private String _resourcePath = "/imgs/rowBtns/";
	private String _plainPath = "plain/";
	private String _shadowPath = "shadow/";
	private VideoFile videoFile;
	
	private JLabel lblSubtitleName;

	/**
	 * Create the panel.
	 */
	public InputClipRow(File inputFile) {
		
		videoFile = new VideoFile(inputFile);
		
		if(!videoFile.isValid()){
			StaticUtils.errorMsg(inputFile.getName() + " is invalid or unsupported video file");
			return;
		}
			
		
		setBorder(null);
		setLayout(null);
		setBackground(new Color(245, 188, 143));
		
		JLabel btnImgUp = new JLabel("");
		btnImgUp.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
		btnImgUp.addMouseListener(new MouseBtnImgListener());
		btnImgUp.setName("moveUp.png");
		btnImgUp.setIcon(new ImageIcon(InputClipRow.class.getResource(_resourcePath + _plainPath + btnImgUp.getName())));
		btnImgUp.setBounds(464, 9, 16, 16);
		add(btnImgUp);
		
		JLabel btnImgDown = new JLabel("");
		btnImgDown.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
		btnImgDown.addMouseListener(new MouseBtnImgListener());
		btnImgDown.setName("moveDown.png");
		btnImgDown.setIcon(new ImageIcon(InputClipRow.class.getResource(_resourcePath + _plainPath + btnImgDown.getName())));
		btnImgDown.setBounds(464, 59, 16, 16);
		add(btnImgDown);
		
		JLabel btnImgDelete = new JLabel("");
		btnImgDelete.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
		btnImgDelete.addMouseListener(new MouseBtnImgListener());
		btnImgDelete.setName("delete.png");
		btnImgDelete.setIcon(new ImageIcon(InputClipRow.class.getResource(_resourcePath + _plainPath + btnImgDelete.getName())));
		btnImgDelete.setBounds(0, 0, 16, 16);
		add(btnImgDelete);
		
		JLabel previewImg = new JLabel("");
		previewImg.setName("PREVIEW");
		previewImg.setIcon(videoFile.getThumb());
		previewImg.setBounds(10, 11, 64, 64);
		add(previewImg);
		
		JLabel lblFileName = new JLabel(inputFile.getName());
		lblFileName.setFont(new Font("Tahoma", Font.BOLD, 12));
		lblFileName.setBounds(84, 8, 360, 14);
		add(lblFileName);
		
		int[] duration = StaticUtils.splitToComponentTimes(videoFile.getDuration());
		String.format("%02d", duration[0]);
		String parsedDuration = String.format("%02d", duration[0]) + ":" + String.format("%02d", duration[1]) + ":" + String.format("%02d", duration[2]);
		
		JLabel lblSettings = new JLabel(videoFile.getDiameters()+"@" + String.format("%.3f", videoFile.getFramerate()) + "  duration:" + parsedDuration);
		lblSettings.setFont(new Font("Tahoma", Font.PLAIN, 11));
		lblSettings.setBounds(84, 28, 220, 14);
		add(lblSettings);
		
		Vector<String> comboBoxItems=new Vector<String>();
		String[] audioStreams = videoFile.getAudioStreams();
		for (int i=0; i<audioStreams.length; i++)
			comboBoxItems.add(audioStreams[i]);
		comboBoxItems.add("no audio");
		JComboBox<String> choiseSoundTrack  = new JComboBox<String>(comboBoxItems);
		choiseSoundTrack.setBackground(new Color(245, 188, 143, 0));
		choiseSoundTrack.setFont(new Font("Tahoma", Font.PLAIN, 10));
		choiseSoundTrack.setBounds(298, 26, 146, 18);
		add(choiseSoundTrack);
		
		JSeparator separator = new JSeparator();
		separator.setForeground(new Color(199, 146, 103));
		separator.setBackground(new Color(255, 204, 0));
		separator.setBounds(84, 48, 360, 2);
		add(separator);
		
		JToggleButton tglbtnAddsubtitle = new JToggleButton("");
		//tglbtnAddsubtitle.setBackground(new Color(245, 188, 143, 100));
		tglbtnAddsubtitle.setIcon(new ImageIcon(InputClipRow.class.getResource("/imgs/rowBtns/add_sbttl.png")));
		tglbtnAddsubtitle.setName("/imgs/rowBtns/add_sbttl.png");
		tglbtnAddsubtitle.setBounds(185, 53, 91, 22);
		tglbtnAddsubtitle.addActionListener(new toggleListener());
		add(tglbtnAddsubtitle);
		
		JToggleButton tglbtnDeinterlace = new JToggleButton("");
		tglbtnDeinterlace.setToolTipText("Choose this option if you see horizontal lines in your video.");
		tglbtnDeinterlace.setIcon(new ImageIcon(InputClipRow.class.getResource("/imgs/rowBtns/deinterlace.png")));
		tglbtnDeinterlace.setName("/imgs/rowBtns/deinterlace.png");
		tglbtnDeinterlace.setBounds(84, 53, 91, 22);
		tglbtnDeinterlace.addActionListener(new toggleListener());
		add(tglbtnDeinterlace);
		
		lblSubtitleName = new JLabel("");
		lblSubtitleName.setBounds(280, 53, 164, 22);
		add(lblSubtitleName);
		
		
		
		//System.out.println(Integer.parseInt(choiseSoundTrack.getSelectedItem().substring(choiseSoundTrack.getSelectedItem().length()-1)));

	}
	
	public boolean isExist(){
		return videoFile.isValid();
	}
	
	private class MouseBtnImgListener extends MouseAdapter{
		
		
		@Override
		public void mouseEntered(MouseEvent e) {
			JLabel event = (JLabel)e.getComponent(); 
			event.setIcon(new ImageIcon(InputClipRow.class.getResource(_resourcePath + _shadowPath + event.getName())));
		}
		@Override
		public void mouseExited(MouseEvent e) {
			JLabel event = (JLabel)e.getComponent(); 
			event.setIcon(new ImageIcon(InputClipRow.class.getResource(_resourcePath + _plainPath + event.getName())));
		}
		
		@Override
		public void mousePressed(MouseEvent e) {
			JLabel event = (JLabel)e.getComponent(); 
			event.setIcon(new ImageIcon(InputClipRow.class.getResource(_resourcePath + _plainPath + event.getName())));
		}
		
		@Override
		public void mouseReleased(MouseEvent e) {
			JLabel event = (JLabel)e.getComponent(); 
			event.setIcon(new ImageIcon(InputClipRow.class.getResource(_resourcePath + _shadowPath + event.getName())));
			System.out.println(event.getParent().getName());
			if (event.getName().equals("delete.png"))
				((FilesPanel)(event.getParent().getParent().getParent().getParent().getParent().getParent())).deleteClip(Integer.parseInt(event.getParent().getName())); //long way to get back to FilesPanel
			if (event.getName().equals("moveUp.png"))
				((FilesPanel)(event.getParent().getParent().getParent().getParent().getParent().getParent())).moveUp(Integer.parseInt(event.getParent().getName()));
			if (event.getName().equals("moveDown.png"))
				((FilesPanel)(event.getParent().getParent().getParent().getParent().getParent().getParent())).moveDown(Integer.parseInt(event.getParent().getName()));
			
			
		}
		
	}
	
	private class toggleListener implements ActionListener{

		@Override
		public void actionPerformed(ActionEvent e) {
			if (e.getSource() instanceof JToggleButton){
				JToggleButton btn = (JToggleButton)e.getSource();
				if (btn.getName().equals("/imgs/rowBtns/add_sbttl.png")){
					if (!btn.isSelected()){
						InputClipRow.this.videoFile.setSubtitle(null);
						InputClipRow.this.lblSubtitleName.setText("");
					} else {
						JFileChooser subtitleChoose = new JFileChooser();
						subtitleChoose.setDialogType(JFileChooser.OPEN_DIALOG);
						subtitleChoose.setFileSelectionMode(JFileChooser.FILES_ONLY);
						subtitleChoose.setDialogTitle("Choose subtitles file...");
						FileFilter subtitleFilter = new FileNameExtensionFilter("Subtitles files (*.srt, *.sub)", new String[]{"srt", "sub"});
						subtitleChoose.setAcceptAllFileFilterUsed(false);
						subtitleChoose.addChoosableFileFilter(subtitleFilter);
						if (subtitleChoose.showOpenDialog(InputClipRow.this) == JFileChooser.APPROVE_OPTION){
							InputClipRow.this.videoFile.setSubtitle(subtitleChoose.getSelectedFile());
							InputClipRow.this.lblSubtitleName.setText(InputClipRow.this.videoFile.getSubtitle().getName());
						} else {
							btn.setSelected(false);
						}
					}
					
				}
				
				
				else if (btn.getName().equals("/imgs/rowBtns/deinterlace.png")){
					InputClipRow.this.videoFile.setDeinterlace(!InputClipRow.this.videoFile.getDeinterlace());
				}
			}
		}
		
	}
}
