package gui;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;

public class PanelForTab {

	/**
	 * Create the panel.
	 */
	public PanelForTab(JTabbedPane parentTabbedPane, String name, String imageResource) {
		Icon tabIcon = new ImageIcon(PanelForTab.class.getResource(imageResource));
		Component panelToAdd = null;
		String toolTip = "";
		if      (name.toLowerCase().equals("files"))
		{
			panelToAdd = new FilesPanel();
			toolTip = "Add files";
		}
		else if (name.toLowerCase().equals("settings"))
		{
			panelToAdd = new SettingsPanel();
			toolTip = "Choose settings and run";
		}
		else if (name.toLowerCase().equals("about"))
		{
			panelToAdd = new aboutPanel();
			toolTip = "About MGTranscoder";
		}
		
		if (panelToAdd != null) //if the name is incorrect just don't add
			parentTabbedPane.addTab(null, tabIcon, panelToAdd, toolTip);
	}

}
