package utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlHandler {
	
	private Document _doc;
	private NodeList _loadedList;
	
	public XmlHandler(String stream){
		try {
			_doc = StaticUtils.loadXMLFromString(stream);
			_doc.getDocumentElement().normalize();
		} catch (Exception e) {
			return;
		}
		
		
	}
	
	public XmlHandler(File file){
		try {
			_doc = StaticUtils.loadXMLFromFile(file);
			_doc.getDocumentElement().normalize();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {                           //TODO add exception reactions
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void loadNodesByName(String name){
		_loadedList = _doc.getElementsByTagName(name);
	}
	
	
	public boolean isEmpty(){
		return (_doc == null || _loadedList == null || _loadedList.getLength() == 0);
	}
	
	public int hasVideo(){
		for (int i = 0; i<_loadedList.getLength();i++)
			if (getAttribute("codec_type", i).equals("video"))
				return i;
		return -1;
				
	}
	
	public boolean isImage(){
		if (getAttribute("format_name", 0).equals("image2"))
				return true;
		return false;
				
	}
	
	public String getAttribute(String name, int numberOfNodeInList){
		Element node = ((Element)_loadedList.item(numberOfNodeInList));
		if (node == null)
			return null;
		return node.getAttribute(name);
	}
	
	public String getAttribute(NodeList nodeList ,String name, int numberOfNodeInList){
		Node node = nodeList.item(numberOfNodeInList);
		if (node == null)
			return null;
		NamedNodeMap map = node.getAttributes();
		String returnStr = "";
		for (int i=0; i<map.getLength(); i++)
			if(map.item(i).getNodeName().equals(name))
				return map.item(i).getNodeValue();
		return returnStr;
	}
	
	public int getLength(){
		return _loadedList.getLength();
	}
	
	public String[] getAudioStreamRepresentation(){
		List<String> streams = new ArrayList<String>();
		int channelCout = 0;
		for (int i = 0; i<_loadedList.getLength();i++){
			String lang = "undefined";
			if (getAttribute("codec_type", i).equals("audio")){
				channelCout++;
				NodeList tagNode = _loadedList.item(i).getChildNodes();
				for(int j=1; j<(tagNode.getLength())*2; j+=2){ //xml parser sees whitespace as node, so should travel on odds
					if(getAttribute(tagNode, "key", j) != null && getAttribute(tagNode, "key", j).equals("language")){
						String langVal = getAttribute(tagNode, "value", j);
						if (!langVal.equals("und"))
							lang = langVal;
					}
				}
				streams.add("Audio " + channelCout + ", lang:" + lang);
			}
		}
		String[] toStr = streams.toArray(new String[streams.size()]);
		return toStr;		
	}
	

}
