package com.smu.cse7392.presconverter;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.model.Picture;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.hslf.usermodel.SlideShow;

public class PresentationConverter extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		String content = request.getParameter("content");
		convertSlides();

	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		doGet(request, response);
	}

	public void convertSlides() throws IOException {
		
		String tmpDir = "input-files";
		PrintWriter out;
		ServletContext context = getServletContext();
		String tmpDirPath = context.getRealPath(tmpDir);
		// TODO Auto-generated method stub
		SlideShow ppt = new SlideShow(new HSLFSlideShow(tmpDirPath + "\\Cloud.ppt"));
		// extract all pictures contained in the presentation
		Slide[] slideArray = ppt.getSlides();
		// slideArray[0].
		PictureData[] pdata = ppt.getPictureData();
		for (int i = 0; i < pdata.length; i++) {
			PictureData pict = pdata[i];

			// picture data
			byte[] data = pict.getData();

			int type = pict.getType();
			String ext;
			switch (type) {
			case Picture.JPEG:
				ext = ".jpg";
				break;
			case Picture.PNG:
				ext = ".png";
				break;
			case Picture.WMF:
				ext = ".wmf";
				break;
			case Picture.EMF:
				ext = ".emf";
				break;
			case Picture.PICT:
				ext = ".pict";
				break;
			default:
				continue;
			}
			FileOutputStream out1 = new FileOutputStream("data\\pict_" + i + ext);
			out1.write(data);
			out1.close();

		}

	}

}
