package com.smu.cse7392.prefixchecker;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.hp.hpl.jena.n3.turtle.TurtleParseException;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.FileManager;

public class PrefixCheckServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		String content = request.getParameter("content");
		fillInThePResponse(response, content);

	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		doGet(request, response);
	}

	private static boolean prefixChecker(Map<String, String> nsPrefixMap)
			throws PrefixCheckerException {
		// LOAD Ontology, contents of a4Prefixes.rdfs
		// @prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>.
		// @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.
		// @prefix foaf: <http://xmlns.com/foaf/0.1/>.
		// @prefix xsd: <http://www.w3.org/2001/XMLSchema#>.
		// @prefix rdfs: <http://www.w3.org/TR/2004/REC-rdf-schema-20040210/#>.
		// @prefix dc: <http://purl.org/dc/elements/1.1/>.
		// @prefix sioc: <http://rdfs.org/sioc/ns#>.
		// @prefix sioct: <http://rdfs.org/sioc/types#>.
		// @prefix skos: <http://www.w3.org/2004/02/skos/core#>.
		Model schema = FileManager.get().loadModel(
				"http://lyle.smu.edu/~hheikal/7392/a4Prefixes.rdfs", "N3");

		// Create an RDFS inference model from the Raw Model
		InfModel infmodel = ModelFactory.createRDFSModel(schema);

		// getNsPrefixMap() - Return a copy of the internal mapping from names
		// to URI strings.
		Map<String, String> prefixReferenceMap = infmodel.getNsPrefixMap();
		for (String prefixKey : nsPrefixMap.keySet()) {
			if (prefixReferenceMap.containsKey(prefixKey)) {
				if (!prefixReferenceMap.get(prefixKey).equals(
						nsPrefixMap.get(prefixKey))) {
					throw new PrefixCheckerException(
							PrefixCheckerException.PREFIX_NAMESPACE_ERROR,
							"Error in @PREFIX of " + prefixKey + ":\n"
									+ "correct one: @PREFIX " + prefixKey
									+ ": " + prefixReferenceMap.get(prefixKey)
									+ "\n" + "Problem in: @PREFIX " + prefixKey
									+ ": " + nsPrefixMap.get(prefixKey));
				}
			} else if (prefixReferenceMap.containsValue(nsPrefixMap
					.get(prefixKey))) {
				// retrieve the key for a specific value from the referece map
				String refKey = null;
				for (String s : prefixReferenceMap.keySet()) {
					if (prefixReferenceMap.get(s).equals(
							nsPrefixMap.get(prefixKey))) {
						refKey = s;
					}
				}
				if (!refKey.equals(prefixKey)) {
					throw new PrefixCheckerException(
							PrefixCheckerException.PREFIX_URI_ERROR,
							"Error in @PREFIX of " + refKey + ":\n"
									+ "correct one: @PREFIX " + refKey + ": "
									+ prefixReferenceMap.get(refKey) + "\n"
									+ "Problem in: @PREFIX " + prefixKey + ": "
									+ nsPrefixMap.get(prefixKey));
				}
			}
		}
		return true;
	}

	protected void fillInThePResponse(HttpServletResponse response,
			String fileContents) {
		String n3Directory = "input-files";
		PrintWriter out;
		try {
			ServletContext context = getServletContext();
			String realDirectory = context.getRealPath(n3Directory);
			// write the POST request to file in the server
			BufferedWriter bufferWriter = new BufferedWriter(new FileWriter(
					realDirectory + "/N3File.n3"));
			bufferWriter.write(fileContents);
			bufferWriter.close();

			// create jena model out of the input file
			String result = null;
			try {
				Model data = FileManager.get().loadModel(
						"file:" + realDirectory + "/N3File.n3", "N3");

				Map<String, String> nsPrefixMap = data.getNsPrefixMap();
				
				try {
					prefixChecker(nsPrefixMap);
					result = "Input File is ok";
				} catch (PrefixCheckerException e) {
					// TODO Auto-generated catch block
					result = e.toString();
				}
			} catch (TurtleParseException tpe) {
				result = tpe.toString();
			}

			out = response.getWriter();
			response.setContentType("text/plain");
			out.println(result);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}