package com.smu.cse7392.prefixchecker;

public class PrefixCheckerException extends Exception {

	private static final long serialVersionUID = 1L;

	// 1000 series : Error in Prefix
	public static final int PREFIX_NAMESPACE_ERROR = 1001;
	public static final int PREFIX_URI_ERROR = 1002;

	private int causeCode = 0;
	private String reason = "";

	/**
	 * Contructor for a new PrefixCheckerException
	 * 
	 * @param aCode
	 *            : Cause code using one of the constants in this class.
	 * @param aReason
	 *            : String describing the fault in more details.
	 */
	public PrefixCheckerException(int aCode, String aReason) {
		this.causeCode = aCode;
		this.reason = aReason;
	}

	/**
	 * Retrieve the cause code as an integer.
	 * 
	 * @return Cause code as an int.
	 */
	public int getCauseCode() {
		return this.causeCode;
	}

	/**
	 * Retrieve the reason string. Not that this is not the same this as the
	 * cause code rather a more detailed explanation fot the fault.
	 * 
	 * @return Reason String
	 */
	public String getReason() {
		return this.reason;
	}

	public String getCauseCodeString() {
		switch (this.causeCode) {
		case PREFIX_NAMESPACE_ERROR:
			return "Error in Prefix NameSpace";
		case PREFIX_URI_ERROR:
			return "Error in Prefix URI";
		default:
			return "Unknown cause code";
		}
	}

	/**
	 * 
	 * @return The exception in form
	 *         "PrefixCheckerException CauseCode=[code] ([codeString]) Reason=[reason]"
	 */
	public String toString() {
		return "PrefixCheckerException CauseCode=" + this.causeCode + " ("
				+ getCauseCodeString() + ") Reason=" + this.reason;
	}

}
