package org.bm.p2p.navigablep2p;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.Logger;
import org.bm.p2p.navigablep2p.test.Log4jExample;

public class Graph {
	static Logger logger = Logger.getLogger(Graph.class.getName());
	private ArrayList<Node> nodes;

	public ArrayList<Node> getNodes() {
		return nodes;
	}

	public void setNodes(ArrayList<Node> nodes) {
		this.nodes = nodes;
	}

	// ʼ磬ڵΪ0
	public Graph() {
		super();
		nodes = new ArrayList<Node>();
	}

	// ʼ磬ڵΪsizeڵ֮ûб߽
	public Graph(int size) {
		super();
		nodes = new ArrayList<Node>();
		for (int i = 0; i < size; i++) {
			System.out.print(i + ": ");
			nodes.add(new Node());
		}
	}

	// ģBootStrapƣоѡһڵ㷵
	public Node bootstrap() {
		Random random = new Random();
		if (nodes.size() > 0) {
			int chosedNodeIdx = random.nextInt(nodes.size());
			return nodes.get(chosedNodeIdx);
		}
		return null;
	}

	// ʼĵһڵ
	public void initializeTheFirstNode(Node node) {
		nodes.add(node);
	}

	// OnlyInWalks
	// inNeighborsrandom walk
	public int onlyInWalks(Node joiningNode, Node nowNode) {
		int messageNum = 0;
		int i;
		while (true) {
			// ھӸ
			int inNeighborNum = nowNode.getInNeighborNum();
			int distance = joiningNode.getDistanceFrom(nowNode);
			int minInDistance = nowNode.getInMinDistance(); //ھӵС
			// 1/ھӸ+1ĸʽǰڵڵĳھ
			Random random = new Random();
			int randomNum = random.nextInt(inNeighborNum+1);
			
			// ǰڵڵĳھ
			if (randomNum==inNeighborNum) {
				// ڵ㷢Ϣǰڵڵĳھ
				messageNum++;
				joiningNode.setOutNeighbor(nowNode, distance);
				// stolen link
				// distanceͰھӲΪգ
				//if (nowNode.getInNeighbor(distance)!=null) {
				//	Node thirdNode = nowNode.getInNeighbor(distance);
				//	messageNum++;
				//	Node forthNode = thirdNode.getOutNeighbor(distance);
					//if (!=null) {
						
					//}
				//}
				// ڵ뵱ǰڵھ
				nowNode.setInNeighbor(joiningNode, distance);
				break;
			}
			else { // ת
				// ڵ뵱ǰڵ˳ھ
				nowNode.setIncidentalNeighbor(joiningNode, distance);
				joiningNode.setIncidentalNeighbor(nowNode, distance);
				// ֲָĵͷֲѡһڵ
				do {
					random = new Random();
					randomNum = random.nextInt((int)Math.pow(2, Node.BUCKETS-minInDistance)-1)+1;
					for (i = 0;i<Node.BUCKETS-minInDistance;i++) {
						if (randomNum>=Math.pow(2, i)&&randomNum<Math.pow(2, i+1)) break;
					}
					
				} while (nowNode.getInNeighbor(minInDistance+i)==null);
				
			}
			//һڵ
			nowNode = nowNode.getInNeighbor(minInDistance+i);
			messageNum++;
			
		}
		
		return messageNum;
	}
	

	// OnlyOutWalks
	// outNeighborsrandom walk
	public int onlyOutWalks(Node joiningNode, Node nowNode) {
		int messageNum = 0;
		int i;
		while (true) {
			// ھӸ
			int outNeighborNum = nowNode.getOutNeighborNum();
			int distance = joiningNode.getDistanceFrom(nowNode);
			int minOutDistance = nowNode.getOutMinDistance(); //ھӵС
			// 1/ھӸ+1ĸʽǰڵڵĳھ
			Random random = new Random();
			int randomNum = random.nextInt(outNeighborNum+1);
			
			// ǰڵڵĳھ
			if (randomNum==outNeighborNum) {
				// ڵ㷢Ϣǰڵڵĳھ
				messageNum++;
				joiningNode.setInNeighbor(nowNode, distance);
				// stolen link
				// distanceͰھӲΪգ
				//if (nowNode.getInNeighbor(distance)!=null) {
				//	Node thirdNode = nowNode.getInNeighbor(distance);
				//	messageNum++;
				//	Node forthNode = thirdNode.getOutNeighbor(distance);
					//if (!=null) {
						
					//}
				//}
				// ڵ뵱ǰڵھ
				nowNode.setOutNeighbor(joiningNode, distance);
				break;
			}
			else { // ת
				// ڵ뵱ǰڵ˳ھ
				nowNode.setIncidentalNeighbor(joiningNode, distance);
				// ֲָĵͷֲѡһڵ
				do {
					random = new Random();
					randomNum = random.nextInt((int)Math.pow(2, Node.BUCKETS-minOutDistance)-1)+1;
					for (i = 0;i<Node.BUCKETS-minOutDistance;i++) {
						if (randomNum>=Math.pow(2, i)&&randomNum<Math.pow(2, i+1)) break;
					}
					
				} while (nowNode.getOutNeighbor(minOutDistance+i)==null);
				
			}
			//һڵ
			nowNode = nowNode.getOutNeighbor(minOutDistance+i);
			messageNum++;
			
		}
		
		return messageNum;
	}
	
	public int addNode6(Node node, int type) {
		int messageNum = 0;
		Node nowNode;
		ArrayList<Node> iNeighbors;
		// ϵڵ
		Node bootstrapNode = bootstrap();
		for (int i = 0; i < Node.BUCKETS; i++) {
			iNeighbors = bootstrapNode.getInNeighbors(i);
			// ϵڵľΪiھӴ
			if (iNeighbors.size()>0)
				for (int j=0;j<iNeighbors.size();j++){
					// ׼ھӷϢ
					nowNode = iNeighbors.get(j);
					if (nowNode !=null)
					messageNum += this.onlyInWalks(node, nowNode);
				}
		}
		for (int i = 0; i < Node.BUCKETS; i++) {
			iNeighbors = bootstrapNode.getOutNeighbors(i);
			// ϵڵľΪiھӴ
			if (iNeighbors.size()>0)
				for (int j=0;j<iNeighbors.size();j++){
					// ׼ھӷϢ
					nowNode = iNeighbors.get(j);
					if (nowNode !=null)
					messageNum += this.onlyOutWalks(node, nowNode);
				}
		}
		// ϵڵڵھ
		node.setOutNeighbor(bootstrapNode, node.getDistanceFrom(bootstrapNode));
		bootstrapNode.setInNeighbor(node, node.getDistanceFrom(bootstrapNode));

		nodes.add(node);
		return messageNum;
	}
	
	
	// ڵnode, ͵Ϣ
	// type=1ʾȱʡʽ
	// Żʽ1stolen linkҵΪdistanceĳڵʱͬڵ㻹Уѡȡһ
	// ѡȡڵͬڵ㻹УͰѸѡڵڵھӣѡСڵĸ
	// 2ҵΪdistanceĳڵʱͬڵ㻹ûУͲҺͼڵdistanceнڵ㣬Ѽڵǵھ
	// ˳ڵҪҪΪʱʵѡԪء
	public int addNode5(Node node, int type) {
		
		int maxDepth = Node.BUCKETS;
		int messageNum = 0;
		// ϵڵ
		Node bootstrapNode = bootstrap();

		// ģ͵Ϣ
		class Message {
			Node srcNode; // ڵ
			Node nowNode; // ǰڵ
			int depth;    // ǰ

			Message(Node srcNode, Node nowNode, int depth) {
				this.srcNode = srcNode;
				this.nowNode = nowNode;
				this.depth = depth;
			}
		}
		
		// ʼϢϵڵھӽڵ㷢Ϣ
		Queue<Message> visitedNodes = new LinkedList<Message>();
		Message visitedNode;
		for (int i = 0; i < Node.BUCKETS; i++) {
			ArrayList<Node> iNeighbors = bootstrapNode.getOutNeighbors(i);
			// ϵڵľΪiھӴ
			if (iNeighbors.size()>0)
				for (int j=0;j<iNeighbors.size();j++){
					// ׼ھӷϢ
					visitedNode = new Message(node, iNeighbors.get(j), 0);
					visitedNodes.add(visitedNode);
				}
		}
		
		// ϵڵڵھ
		node.setOutNeighbor(bootstrapNode, node.getDistanceFrom(bootstrapNode));
		bootstrapNode.setOutNeighbor(node, node.getDistanceFrom(bootstrapNode));
		
		
		int distance;
		// ׼͵ϢΪ
		while (visitedNodes.size() > 0) {
			// ȡһϢ
			visitedNode = visitedNodes.remove();
			// Ϣ
			messageNum++;
			Node srcNode = visitedNode.srcNode;
			Node nowNode = visitedNode.nowNode;
			
			// õǰڵͼڵľ
			distance = srcNode.getDistanceFrom(nowNode);
			// logger.info(messageNum+"th node, position = "+visitedNode.nowNode.getNodePosition());
			
			// ϢСֵ
			if (visitedNode.depth <= maxDepth) {
				/**
				 * Ϊi
				 * СiĽڵN(<i)=2^i
				 * iĽڵN(=i)=2^i
				 * iĽڵN(>i)=2^i-2^(i+1)
				 * 
				 * (<i,=i,>i)һתĸþĽڵɷ
				 * 1/2^i, 1/2^i, 1/(2^n-2^(i+1)) ==>  1, 1, 1/(2^(n-i)-2) ==> 2^(n-i)-2, 2^(n-i)-2, 1
				 */
				Random random = new Random();
				//[0, 2^(n-i+1)-3)ѡһ
				int randomNum = random.nextInt((int) Math.pow(2, (Node.BUCKETS
						- distance + 1)) - 3);
				// С1iھת
				if (randomNum < 1) { // 
					ArrayList<Node> nextNodes = new ArrayList<Node>();
					//þdistanceھ
					for (int i = distance + 1; i < Node.BUCKETS; i++) {
						ArrayList<Node> iNeighbors = nowNode.getOutNeighbors(i);
						if (iNeighbors.size()>0)
							for (int j=0;j<iNeighbors.size();j++){
								if (iNeighbors.get(j)!=srcNode) nextNodes.add(iNeighbors.get(j));
							}
					}
					if (nextNodes.size() > 0) {
						Random random2 = new Random();
						int chosedIdx = random2.nextInt(nextNodes.size());
						Message message = new Message(srcNode, nextNodes
								.get(chosedIdx), visitedNode.depth + 1);
						visitedNodes.add(message);
					}

				} else if (randomNum < (int) Math.pow(2,
						(Node.BUCKETS - distance) - 1)) { // 
					Node nextNode = nowNode.getOutNeighbor(distance);
					if (nextNode != null
							&& nextNode != srcNode) {
						Message message = new Message(srcNode, nextNode, visitedNode.depth + 1);
						visitedNodes.add(message);
					}

				} else { // С
					ArrayList<Node> nextNodes = new ArrayList<Node>();
					for (int i = distance - 1; i >= 0; i--) {
						ArrayList<Node> iNeighbors = nowNode.getOutNeighbors(i);
						if (iNeighbors.size()>0)
							for (int j=0;j<iNeighbors.size();j++){
								if (iNeighbors.get(j)!=srcNode) nextNodes.add(iNeighbors.get(j));
							}
					}
					if (nextNodes.size() > 0) {
						Random random2 = new Random();
						int chosedIdx = random2.nextInt(nextNodes.size());
						Message message = new Message(srcNode, nextNodes
								.get(chosedIdx), visitedNode.depth + 1);
						visitedNodes.add(message);
					}

				
				}
			}
			nowNode.setOutNeighbor(srcNode, distance);
			
			//1/maxStepthھ
			Random random = new Random();
			int chosedIdx = random.nextInt(5);
			if (chosedIdx==1) {
			//ڵΪǰڵھ
			if (nowNode.getOutNeighbor(distance)!=null) {
				srcNode.setOutNeighbor(nowNode, distance);
			}
			else {
				routingToAllNodesLessthanDistance2(srcNode,nowNode,distance-1);
			}
			// ھҲӽȥ
			}
		}

		nodes.add(node);
		return messageNum;
	}

	// ҺͽڵnodeľСڵdistanceнڵ()
	public int routingToAllNodesLessthanDistance2(Node srcNode, Node node,
			int distance) {
		class NodeAndDistance {
			Node node;
			int distance;

			NodeAndDistance(Node node, int distance) {
				this.node = node;
				this.distance = distance;
			}
		}
		;
		int numth = 0;
		Queue<NodeAndDistance> visitedNodes = new LinkedList<NodeAndDistance>();
		NodeAndDistance visitedNode = new NodeAndDistance(node, distance);
		visitedNodes.add(visitedNode);
		while (visitedNodes.size() > 0) {
			visitedNode = visitedNodes.remove();
			numth++;
			// visit node
			//srcNode.setNeighbor(visitedNode.node, distance + 1);
			visitedNode.node.setOutNeighbor(srcNode, distance + 1);
			logger.info(numth + "th node, position = "
					+ visitedNode.node.getNodePosition());
			for (int i = 0; i <= visitedNode.distance; i++) {
				if (visitedNode.node.getOutNeighbor(i) != null) {
					NodeAndDistance nextNode = new NodeAndDistance(
							visitedNode.node.getOutNeighbor(i), i - 1);

					visitedNodes.add(nextNode);
				}
			}
		}
		return numth;
	}

	// ҺͽڵnodeľСڵdistanceнڵ
	public int routingToAllNodesLessthanDistance(Node node, int distance,
			int numth) {
		// 
		int i;
		for (i = 0; i < Node.BUCKETS; i++)
			if (node.getOutNeighbor(i) != null)
				break;
		if (distance < i)
			return numth - 1;
		logger.info(numth + "th node, distance = " + distance + " position = "
				+ node.getNodePosition());
		Node rightNode = node.getOutNeighbor(distance);
		if (rightNode != null && rightNode != node)
			numth += routingToAllNodesLessthanDistance(rightNode, distance - 1,
					numth + 1);
		// Node leftNode = node.getNeighbor(distance-1);
		// if (leftNode != null&&leftNode!=node)

		numth += routingToAllNodesLessthanDistance(node, distance - 1,
				numth + 1);
		return numth;
	}

	// ѽڵbootstrapھӽڵڵnode
	public void addNodeNeighbors(Node node, Node bootstrapNode) {
		// bootstrapڵھӼ뵽ڵھ
		int distance = node.getDistanceFrom(bootstrapNode);
		node.setOutNeighbor(bootstrapNode, distance);
		bootstrapNode.setOutNeighbor(node, distance);

		// distanceھ
		for (int j = distance + 1; j < Node.BUCKETS; j++) {
			if (bootstrapNode.getOutNeighbors(j).size() > 0) {
				for (int k = 0; k < bootstrapNode.getOutNeighbors(j).size(); k++) {
					node.setOutNeighbor(bootstrapNode.getOutNeighbors(j).get(k), j);
					//bootstrapNode.getOutNeighbors(j).get(k).setOutNeighbor(node, j);
				}
			}
		}
		// Сdistanceھ
		for (int j = distance - 1; j >= 0; j--) {
			if (bootstrapNode.getOutNeighbors(j).size() > 0) {
				for (int k = 0; k < bootstrapNode.getOutNeighbors(j).size(); k++) {
					node.setOutNeighbor(bootstrapNode.getOutNeighbors(j).get(k),
							distance);
					//bootstrapNode.getOutNeighbors(j).get(k).setOutNeighbor(node,
					//		distance);
				}
			}
		}
		// distanceھ
		if (bootstrapNode.getOutNeighbors(distance).size() > 0) {
			for (int k = 0; k < bootstrapNode.getOutNeighbors(distance).size(); k++) {
				if (node.getDistanceFrom(bootstrapNode.getOutNeighbors(distance)
						.get(k)) >= 0) {
					node.setOutNeighbor(bootstrapNode.getOutNeighbors(distance)
							.get(k), node.getDistanceFrom(bootstrapNode
							.getOutNeighbors(distance).get(k)));
					//bootstrapNode.getOutNeighbors(distance).get(k).setOutNeighbor(
					//		node,
					//		node.getDistanceFrom(bootstrapNode.getOutNeighbors(
					//				distance).get(k)));
				}
			}
		}
	}

	// ڵ㣺ѡȡBUCKETSڵ㣬ǵھӼ뵽ڵھ
	public int addNode3(Node node) {
		Node bootstrapNode = bootstrap(); // bootstrapڵ
		for (int i = 0; i < Node.BUCKETS; i++) {
			addNodeNeighbors(node, bootstrapNode);
			Random random = new Random();
			int chosedIdx = random.nextInt(bootstrapNode.BUCKETS);
			while (bootstrapNode.getOutNeighbor(chosedIdx) == null)
				chosedIdx = random.nextInt(bootstrapNode.BUCKETS);
			bootstrapNode = bootstrapNode.getOutNeighbor(chosedIdx);
		}
		nodes.add(node);
		return 1;
	}

	public int addNode4(Node node) {
		int messageNum = 0;

		Node bootstrapNode = bootstrap(); // bootstrapڵ
		int distance = node.getDistanceFrom(bootstrapNode);
		if (distance >= 0) {
			node.setOutNeighbor(bootstrapNode, distance);
			bootstrapNode.setOutNeighbor(node, distance);
		}
		for (int i = 0; i < Node.BUCKETS; i++) {
			// bootstrapNode = bootstrap(); // bootstrapڵ
			// һͽڵnodeľΪi½ڵrandomDestNode
			Node srcNode = bootstrapNode;
			Node randomDestNode = new Node(node, i);
			// logger.info("node: "+node.getNodePosition()+
			// " randomdestNode: "+randomDestNode.getNodePosition()+" distance = "+i);
			while (srcNode != randomDestNode && srcNode != null) {
				srcNode = srcNode.getOutNeighbor(srcNode
						.getDistanceFrom(randomDestNode));
				if (srcNode != null) {
					distance = node.getDistanceFrom(srcNode);
					if (distance >= 0) {
						addNodeNeighbors(node, srcNode);
						node.setOutNeighbor(srcNode, distance);
						srcNode.setOutNeighbor(node, distance);
					}
				}
			}
		}
		nodes.add(node);
		return messageNum;
	}

	// ڵnode跢͵Ϣ
	public int addNode2(Node node) {
		int messageNum = 0; // һڵ跢͵Ϣ
		for (int i = 0; i < Node.BUCKETS; i++) {
			// һͽڵnodeľΪi½ڵrandomDestNode
			// Node randomDestNode = new Node(node,i);
			// ڵrandomDestNodeΪĿڵ㣬bootstrapNodeʼ·ɵrandomDestNode
			// мڵڵnodeĳھӣڵnodeЩмڵھ
			// мڵΪգмڵھѾڣ
			// Ѿ֪ĳڵھӺͳھӣͿڵھӺͳھӵľ

			Node bootstrapNode = bootstrap(); // bootstrapڵ
			int maxDestNodeNum = (int) Math.pow(2, Node.BUCKETS / (i + 1)); // ÿηĿڵ
			// ϵڵbootstrapNodeʼڵnodeľΪiĽڵ
			// ϵڵbootstrapNodeͼڵľi
			while ((bootstrapNode != null)
					&& (node.getDistanceFrom(bootstrapNode) > i)) {
				// node.setNeighbor(bootstrapNode,
				// node.getDistanceFrom(bootstrapNode));

				bootstrapNode = bootstrapNode.getOutNeighbor(node
						.getDistanceFrom(bootstrapNode));
				// bootstrapNode.setNeighbor(node,
				// node.getDistanceFrom(bootstrapNode));
				messageNum++;
			}
			if ((bootstrapNode != null)
					&& (node.getDistanceFrom(bootstrapNode) < i)) {
				// node.setNeighbor(bootstrapNode,
				// node.getDistanceFrom(bootstrapNode));
				// bootstrapNode.setNeighbor(node,
				// node.getDistanceFrom(bootstrapNode));
				bootstrapNode = bootstrapNode.getOutNeighbor(i);
				messageNum++;
			}
			if ((bootstrapNode != null)
					&& (node.getDistanceFrom(bootstrapNode) == i)) { // ϵڵͼڵľ=i
				// кϵڵľСiĽڵ㣬Щڵͼڵľ붼i
				// һȵ㷨
				Queue<Node> visitedNodes = new LinkedList<Node>();
				visitedNodes.add(bootstrapNode); // ϵڵѷʽڵ
				int destNodeNum = 0; // ѷʵĽڵ
				// ֻҪѷʽڵûдﵽmaxDestNodeNumңѷʽڵвΪ
				while ((destNodeNum <= maxDestNodeNum)
						&& (visitedNodes.size() > 0)) {
					// ѷʽڵȡһڵ
					Node hasVisitedNode = visitedNodes.remove();
					// ýڵľΪiĳھΪգͰѼڵnodeΪýڵΪiĳھ
					if (hasVisitedNode.getOutNeighbor(i) == null) {
						hasVisitedNode.setOutNeighbor(node, i);
						node.setOutNeighbor(hasVisitedNode, i);
						// maxDestNodeNum = 10000;
					}
					// ýڵΪڵnodeĳھ
					node.setOutNeighbor(hasVisitedNode, i);
					hasVisitedNode.setOutNeighbor(node, i);

					// ִstolen
					// linkhasVisitedNodeһھӽڵ㣬ڵʱԽھԽࡱ
					// for (int k = i+1; k < Node.BUCKETS; k++) {
					// if (hasVisitedNode.getInNeighbor(k)!=null) {
					// hasVisitedNode.getInNeighbor(k).setOutNeighbor(node, k);
					// node.setInNeighbor(hasVisitedNode.getInNeighbor(k), k);
					// }
					// }

					destNodeNum++;
					messageNum++;
					// ʺͽڵhasVisitedNodeľСiнڵ
					for (int j = i - 1; j >= 0; j--) {
						if (hasVisitedNode.getOutNeighbor(j) != null) {
							visitedNodes.add(hasVisitedNode.getOutNeighbor(j));
						}
					}

				}

			}
		}
		nodes.add(node);
		return messageNum;
	}

	// ɾڵ㣬跢͵Ϣ
	// ɾڵھӽڵĳھñɾڵĳھ
	public int delNode(Node node) {
		int messageNum = 0;
		// ɾڵھӽڵбеھ
		int j = 0;
		for (int i = 0; i <= Node.BUCKETS - 1; i++) {
			if (node.getOutNeighbor(i) != null) {
				for (int k = j; k <= i; k++) {
					if (node.getOutNeighbor(k) != null) {
						node.getOutNeighbor(i).setOutNeighbor(node.getOutNeighbor(k), i);
						messageNum++;
						break;
					}
				}
				j = i;
			}
		}
		return messageNum;
	}

	public void delNodes() {
		for (int i = 0; i < nodes.size(); i++) {
			Random random = new Random();
			int chosenNodeIdx = random.nextInt(nodes.size());
			int messageNum = delNode(nodes.get(chosenNodeIdx));
			System.out.println("delNode messageNum: " + messageNum);
			nodes.remove(chosenNodeIdx);
			testRoute();
		}
	}

	/**
	 * ڵnode磬ʹRandom WalkΪڵnodeӱ
	 * 
	 * ڵaһھӽڵbڵcǽڵbĳھӽڵ㣬ô (1) If D(b,c)=D(a,b), Then D(a,c)<D(a,b)
	 * (2) If D(b,c)>D(a,b), Then D(a,c)=D(b,c)>D(a,b) (3) If D(b,c)<D(a,b),
	 * Then D(a,c)=D(a,b)
	 * 
	 * ͨ»ƻNextHops: (1): ԽڵcΪNextHop (2): ѡڵcΪNextHop (3):
	 * ڵ룬ֹͣ
	 */
	/*
	 * public void addNode(Node node) { Node bootstrapNode = bootstrap(); //
	 * bootstrapڵ //int maxSteps = Node.BUCKETS; // ? int maxDistance =
	 * Node.BUCKETS-1, minDistance = 0; int messageNumber =
	 * randomWalk(maxDistance, minDistance, node, bootstrapNode, 0);
	 * System.out.println("messages: " + messageNumber); nodes.add(node); }
	 * 
	 * private int randomWalk(int maxDistance, int minDistance, Node joinNode,
	 * Node concactNode, int messageNumber) { if (messageNumber++ > MAXMESSAGES)
	 * return messageNumber;
	 * 
	 * // üڵϵڵľ int curDistance =
	 * joinNode.getDistanceFrom(concactNode); // 洢 ϵڵھ ڵľ
	 * ϵڵڵľ ȵĽڵ ArrayList<Node> distanceEqualsNodes = new
	 * ArrayList<Node> (); // ϵڵ distanceEqualsNodes.add(concactNode); //
	 * ϵڵھеͬڵ for (int i = curDistance - 1; i>=0;i--) { if
	 * (concactNode.getOutNeighbor(i) != null)
	 * distanceEqualsNodes.add(concactNode.getOutNeighbor(i)); } //
	 * ͬڵбѡһڵ Random random = new Random(); int chosedNodeIdx =
	 * random.nextInt(distanceEqualsNodes.size()); //ýڵ뵽ڵھӽڵ
	 * joinNode.setOutNeighbor(distanceEqualsNodes.get(chosedNodeIdx),
	 * curDistance); //ҪҪڵýڵھأ
	 * distanceEqualsNodes.get(chosedNodeIdx).setOutNeighbor(joinNode,
	 * curDistance);
	 * 
	 * //ѡһڵ㣬ڵСcurDistanceĽڵ㣨ֻһ Node distanceLessNode =
	 * concactNode.getOutNeighbor(curDistance); if (distanceLessNode!=null &&
	 * !distanceLessNode.equals(joinNode)) { // &&
	 * joinNode.getDistanceFrom(distanceLessNode) >= minDistance messageNumber =
	 * randomWalk(maxDistance, minDistance, joinNode, distanceLessNode,
	 * messageNumber); //curDistance-1 }
	 * 
	 * //ѡһڵ㣬ڵcurDistanceĽڵ ArrayList<Node> distanceLargerNodes =
	 * new ArrayList<Node> (); for (int i = curDistance + 1; i <=
	 * maxDistance;i++) { if (concactNode.getOutNeighbor(i) != null)
	 * distanceLargerNodes.add(concactNode.getOutNeighbor(i)); } if
	 * (distanceLargerNodes.size()>0) { random = new Random(); chosedNodeIdx =
	 * random.nextInt(distanceLargerNodes.size()); messageNumber =
	 * randomWalk(maxDistance,minDistance , joinNode,
	 * distanceLargerNodes.get(chosedNodeIdx), messageNumber); //curDistance+1 }
	 * return messageNumber; }
	 * 
	 * private int randomWalk2(int maxDistance, int minDistance, Node joinNode,
	 * Node concactNode, int messageNumber) { if (messageNumber++ > MAXMESSAGES)
	 * return messageNumber;
	 * 
	 * // üڵϵڵľ int curDistance =
	 * joinNode.getDistanceFrom(concactNode); // 洢 ϵڵھ ڵľ
	 * ϵڵڵľ ȵĽڵ ArrayList<Node> distanceEqualsNodes = new
	 * ArrayList<Node> (); // ϵڵ distanceEqualsNodes.add(concactNode); //
	 * ϵڵھеͬڵ for (int i = curDistance - 1; i>=0;i--) { for (int j =
	 * 0; j < Node.K; j++) { if (concactNode.getOutNeighborByIdx(i,j) != null)
	 * distanceEqualsNodes.add(concactNode.getOutNeighborByIdx(i,j)); } } //
	 * ͬڵбѡKڵ if (distanceEqualsNodes.size()>Node.K) { for (int i =
	 * 0; i < Node.K; i++) { Random random = new Random(); int chosedNodeIdx =
	 * random.nextInt(distanceEqualsNodes.size());
	 * //ýڵ뵽ڵھӽڵ(ܳͬĽڵ!)
	 * joinNode.setOutNeighbor(distanceEqualsNodes.get(chosedNodeIdx),
	 * curDistance); //ҪҪڵýڵھأ
	 * distanceEqualsNodes.get(chosedNodeIdx).setOutNeighbor(joinNode,
	 * curDistance); } } else { for (int i = 0; i < distanceEqualsNodes.size();
	 * i++) { //ýڵ뵽ڵھӽڵ(ܳͬĽڵ!) if
	 * (!joinNode.equals(distanceEqualsNodes.get(i))) {
	 * joinNode.setOutNeighbor(distanceEqualsNodes.get(i), curDistance);
	 * //ҪҪڵýڵھأ
	 * distanceEqualsNodes.get(i).setOutNeighbor(joinNode, curDistance);
	 * 
	 * } } }
	 * 
	 * //ѡһڵ㣬ڵСcurDistanceĽڵ㣨ֻһ for (int i = 0; i < Node.K;
	 * i++) { Node distanceLessNode =
	 * concactNode.getOutNeighborByIdx(curDistance,i); if
	 * (distanceLessNode!=null && !distanceLessNode.equals(joinNode)) { // &&
	 * joinNode.getDistanceFrom(distanceLessNode) >= minDistance messageNumber =
	 * randomWalk2(maxDistance, minDistance, joinNode, distanceLessNode,
	 * messageNumber); //curDistance-1 } }
	 * 
	 * //ѡһڵ㣬ڵcurDistanceĽڵ
	 * 
	 * ArrayList<Node> distanceLargerNodes = new ArrayList<Node> (); for (int i
	 * = curDistance + 1; i <= maxDistance;i++) { for (int j = 0; j < Node.K;
	 * j++) { if (concactNode.getOutNeighborByIdx(i,j) != null)
	 * distanceLargerNodes.add(concactNode.getOutNeighborByIdx(i,j)); } } if
	 * (distanceLargerNodes.size()>0) { //Random random = new Random();
	 * //chosedNodeIdx = random.nextInt(distanceLargerNodes.size()); for (int i
	 * = 0; i < distanceLargerNodes.size() ;i++) { messageNumber =
	 * randomWalk2(maxDistance,minDistance , joinNode,
	 * distanceLargerNodes.get(i), messageNumber); //curDistance+1 } } return
	 * messageNumber; }
	 */

	// ΪӱߣKlernbergNavigable Networkģ(ʽ㷨)
	public void addEdgesAccordingToDistance() {
		ArrayList<Node> someNodes = new ArrayList<Node>();
		for (Node node : nodes) { // ÿڵ
			for (int i = 0; i < Node.BUCKETS; i++) { // ΪýڵÿͰһھӽڵ
				someNodes.clear();
				for (Node node2 : nodes) { // ڵѡȡýڵΪiĽڵ㼯
					// ڵ㲻ȣҽڵΪi
					if (!node.equals(node2)
							&& (node.getDistanceFrom(node2) == i)) {
						someNodes.add(node2);
					}
				}
				if (someNodes.size() > 0) { // ڵ㼯ϲΪ
					// System.out.print(i + " ");
					// ӾΪiĽڵ㼯ѡȡһڵ(?ģ͸ӦΪ1/2^i)
					Random random = new Random();
					int chosedNodeIdx = random.nextInt(someNodes.size());
					// ѡȡĽڵ뱾ڵھӽڵб
					node.setOutNeighbor(someNodes.get(chosedNodeIdx), i);// 
																		// (˴Ҳ԰someNodesĳȷڵھӽڵ㣬ܻ·ȵķ)
				}
				// System.out.println();

			}
		}
	}

	// ྶ·,ʵ?
	public int multiPathRoute(Node srcNode, Node destNode, int maxSteps) {
		int steps = 0;

		return steps;
	}

	// ĽڵsrcNode·ɵڵdestNode·ɷν̰·(Greed Routing)
	// steps>0ʾ·ɳɹstepsĴС·,steps=-1ʾж,steps=0ʾmaxSteps
	// ·ͣҲһڵʱ1ʾʧܣ2ʾѡڶһڵ
	public int route(Node srcNode, Node destNode, int maxSteps, int routeType) {
		int steps = 0;
		// СmaxStepsԴڵ㻹ûеĿڵ㣬
		for (steps = 0; steps <= maxSteps && !srcNode.equals(destNode); steps++) {
			// ȡԴڵsrcNodeĿڵľ
			int distance = srcNode.getDistanceFrom(destNode);
			// srcNodeھӽڵиþھӣ
			if (srcNode.getNeighbor(destNode) != null) {
				// ǰھӽڵ
				srcNode = srcNode.getNeighbor(destNode);
			} else { // srcNodeھӽڵûиþھӣ
				if (routeType == 1) { // ·Ϊ1
					// logger.info("route fail, from "+srcNode.getNodePosition()+" to "+
					// destNode.getNodePosition());
					// srcNode.outputNeighbors();
					return -1; // -1ʾ·ʧ
				} else if (routeType == 2) { // ·Ϊ2
					// srcNodeľСdistanceĽڵѡȡһΪһڵ
					ArrayList<Node> distanceLessNodes = new ArrayList<Node>();
					for (int i = distance - 1; i >= 0; i--) {
						if (srcNode.getOutNeighbor(i) != null)
							distanceLessNodes.add(srcNode.getOutNeighbor(i));
					}
					if (distanceLessNodes.size() > 0) { // ҵ
						Random random = new Random();
						int nextNodeIdx = random.nextInt(distanceLessNodes
								.size());
						srcNode = distanceLessNodes.get(nextNodeIdx);
					} else { // ûҵsrcNodeľdistanceĽڵѡСĽڵ㣬Ϊһڵ
						int i;
						for (i = distance + 1; i < Node.BUCKETS; i++) {
							if (srcNode.getOutNeighbor(i) != null)
								srcNode = srcNode.getOutNeighbor(i);
							break;
						}
						if (i == Node.BUCKETS) // ûҵ·ʧ
							return -1;
					}
				}
			}
		}
		if (steps == -1 || steps > maxSteps) { // ·ʧܴӡlog
			logger.info("route fail, from " + srcNode + " to " + destNode);
			srcNode.outputNeighbors();
		}
		if (steps > maxSteps)
			return 0; // ·ȣ0ʾ·ʧ
		return steps; // 򣬷·
	}

	// ·ܣָ
	// 1··
	// 2·ʧܱ
	public void testRoute() {
		int steps = 0;
		double avgSteps = 0.0; // ƽ·
		double successPercent = 0.0; // ·ɳɹ

		int totalSteps = 0, // ·
		successNumber = 0, // ·ɳɹ
		totalNumber = 0; // ·ɴ
		for (Node srcNode : nodes) { // еÿڵ
			for (Node destNode : nodes) { // 㵽нڵ·
				if (srcNode.equals(destNode))
					continue; // ԴڵĿڵͬһڵ㣬ͽѭ
				steps = route(srcNode, destNode, Node.BUCKETS * Node.BUCKETS, 1);
				// logger.info(steps+" ");

				totalNumber++; // ·ɴ1
				if (steps == 0 || steps == -1) { // ·ʧ
				} else { // ·ɳɹ
					totalSteps += steps; // ·
					successNumber++; // ·ɳɹ1
				}
			}
			// logger.info('\n');
		}
		avgSteps = (double) totalSteps / successNumber; // ƽ· = · /
														// ·ɳɹ
		successPercent = (double) successNumber / totalNumber * 100; // ·ɳɹ =
																		// ·ɳɹ
																		// /
																		// ·ɴ
		logger.info("ƽ· = " + avgSteps);
		logger.info("·ɳɹ = " + successPercent + "%");

	}

	// ṹļ
	public void output(String fileName) {
		PrintWriter fileOutput;
		try {
			fileOutput = new PrintWriter(new BufferedWriter(new FileWriter(
					fileName)));
			// нڵ
			for (int i = 0; i < nodes.size(); i++) {
				Node tmpNode = nodes.get(i);
				fileOutput.print(tmpNode.hashCode() + ", "
						+ tmpNode.getNodePosition().toString() + ": ");
				for (int j = 0; j < Node.BUCKETS; j++) {
					if (tmpNode.getOutNeighbor(j) != null) {
						// fileOutput.print(tmpNode.getOutNeighbor(j).hashCode()+", ");
						fileOutput.print(tmpNode.getOutNeighbor(j)
								.getDistanceFrom(tmpNode)
								+ ", ");

					}
				}
				fileOutput.println();
			}
			fileOutput.close();
		} catch (IOException e) {
			System.err.println("Open graph.out ERROR!");
			e.printStackTrace();
		}

	}

	// ͳϢ1ڵھӸ2ڵھʱЧ
	public void stat() {
		int avgNeighborNum = 0, sumNeighborNum = 0, sumFailPercent = 0, avgFailPercent = 0;
		for (int i = 0; i < nodes.size(); i++) {
			sumNeighborNum += nodes.get(i).getNeighborNum();
			logger.info(i + "th node, neighbor number = "
					+ nodes.get(i).getNeighborNum() + ", durty degree = "
					+ nodes.get(i).getFailNum());
			sumFailPercent += nodes.get(i).getFailNum();
			for (int j = 0; j < Node.BUCKETS; j++) {
				if (nodes.get(i).getOutNeighbor(j) != null)
					logger.info(j + "th neighbor, position = "
							+ nodes.get(i).getOutNeighbor(j).getNodePosition());
			}
		}
		logger.info("ƽڵ = " + sumNeighborNum / nodes.size() + "ƽھʧЧ = "
				+ sumFailPercent / nodes.size());

	}

	public static void main(String[] argv) {
		PropertyConfigurator.configure("sort2.properties");
		// Graph graph = new Graph(64);
		// graph.addEdgesAccordingToDistance();

		Graph graph = new Graph();
		graph.initializeTheFirstNode(new Node());
		for (int i = 0; i < 1024; i++) {
			Node node = new Node();
			int messageNum = graph.addNode4(node);
			logger.info(i + "th node," + "messages: " + messageNum
					+ " neighbor number = " + node.getNeighborNum());

		}
		// graph.routingToAllNodesLessthanDistance2(graph.nodes.get(32),
		// Node.BUCKETS-1);
		graph.testRoute();
		graph.stat();
		// graph.delNodes();
		// graph.output("graph.out2");
		// System.out.println(graph.isOutNeighborNumEqualsInNeighborNum());

	}
}
