/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package ch.simas.nbtostring.ui;

import ch.simas.nbtostring.util.Problem;
import java.awt.Color;

/**
 *
 * @author  Jan Becicka
 */
public class ProblemComponent extends javax.swing.JPanel {
    
    private static final long serialVersionUID = 7087988022269330972L;

    private static Color bgColor =  new Color(240, 240, 240);
    
    /**
     * Creates new form ProblemComponent 
     * @param problem the problem this component should display
     */
    public ProblemComponent(final Problem problem) {
        initComponents();
        icon.setIcon(problem.isFatal()?ErrorPanel.getFatalErrorIcon():ErrorPanel.getNonfatalErrorIcon());
        problemDescription.setText(problem.getMessage());
        validate();
    }

    public void setLightBackground() {
        setBackground(Color.WHITE);
        problemDescription.setBackground(Color.WHITE);
        icon.setBackground(Color.WHITE);
    }
    
    public void setDarkBackground() {
        setBackground(new Color(240, 240, 240));
        problemDescription.setBackground(bgColor);
        icon.setBackground(bgColor);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    icon = new javax.swing.JLabel();
    problemDescription = new javax.swing.JTextArea();

    setBorder(javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3));
    setLayout(new java.awt.GridBagLayout());

    icon.setBackground(javax.swing.UIManager.getDefaults().getColor("TextArea.background"));
    icon.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 6, 1, 6));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    add(icon, gridBagConstraints);

    problemDescription.setEditable(false);
    problemDescription.setLineWrap(true);
    problemDescription.setWrapStyleWord(true);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.weightx = 1.0;
    add(problemDescription, gridBagConstraints);
    problemDescription.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ProblemComponent.class, "ACSD_ProblemDescriptionName")); // NOI18N
    problemDescription.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ProblemComponent.class, "ACSD_ProblemDescriptionDescription")); // NOI18N
  }// </editor-fold>//GEN-END:initComponents
    
    
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel icon;
  private javax.swing.JTextArea problemDescription;
  // End of variables declaration//GEN-END:variables
}
