package eu.danielhernandez.ejemplos.nombreceltibero.managed;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

import eu.danielhernandez.ejemplos.nombreceltibero.generatedsource.Grafias;
import eu.danielhernandez.ejemplos.nombreceltibero.generatedsource.Sonidos;
import eu.danielhernandez.ejemplos.nombreceltibero.generatedsource.SonidosHome;

public class Imagen{
	public void paint(OutputStream out,Object mediaData) throws IOException{
		
		if(mediaData instanceof MediaData && ((MediaData)mediaData).getNombre()!=null){
			List<Grafias> grafias = caracteresCeltibero(simplifica(((MediaData)mediaData).getNombre()));
			List<ImageIcon> imagenes = new ArrayList<ImageIcon>();
			int width = 0;
			int height = 0;
			int posX = 0;
			
			for(Grafias grafia : grafias){
				ImageIcon imageIcon = new ImageIcon(FacesContext.getCurrentInstance().getExternalContext().getResource("/images/" + grafia.getGrImagen()));
				imagenes.add(imageIcon);
				height = imageIcon.getImage().getHeight(null);
				width+=imageIcon.getImage().getWidth(null);
			}
			
			BufferedImage img = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
			Graphics2D graphics2D = img.createGraphics();
			
			for(ImageIcon imageIcon : imagenes){
				graphics2D.drawImage(imageIcon.getImage(), posX, 0, imageIcon.getImage().getWidth(null), imageIcon.getImage().getHeight(null), null);
				posX+=imageIcon.getImage().getWidth(null);
			}
			
			/*ImageIcon img1 = new ImageIcon(FacesContext.getCurrentInstance().getExternalContext().getResource("/images/A.gif"));
			ImageIcon img2 = new ImageIcon(FacesContext.getCurrentInstance().getExternalContext().getResource("/images/I.gif"));
			
			
			int width = img1.getImage().getWidth(null) + img2.getImage().getWidth(null);
			int height = img1.getImage().getHeight(null);
			
			
			BufferedImage img = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
			Graphics2D graphics2D = img.createGraphics();
			
			
			graphics2D.drawImage(img1.getImage(), 0, 0, img1.getImage().getWidth(null), img1.getImage().getHeight(null), null);
			graphics2D.drawImage(img2.getImage(), img1.getImage().getWidth(null), 0 , img2.getImage().getWidth(null), img2.getImage().getHeight(null), null);*/
			graphics2D.setBackground(Color.WHITE);
			
			ImageIO.write(img, "png", out);
		}else{
			//Aqu carga una imagen fija inicial
		}
	}
	
	private List<Grafias> caracteresCeltibero(String nombre){
		List<Grafias> grafias = new ArrayList<Grafias>();
		SonidosHome sonidosHome = new SonidosHome();
		
		for(int i=0;i<nombre.length();i++){
			Sonidos sonido = sonidosHome.findBySoSonido(nombre.substring(i, i+1));
			if(sonido.getGrafias()==null && i+1<nombre.length()){
				sonido = sonidosHome.findBySoSonido(nombre.substring(i, i+2));
				i++;
			}
			grafias.add(sonido.getGrafias());
		}
		
		return grafias;
	}
	
	private String simplifica(String nombre){
		String nombreSimple;
		
		nombreSimple = nombre.toUpperCase();
		nombreSimple = nombreSimple.replaceAll("QU", "Q");
		
		return nombreSimple;
	}
}
