/*
 * Part of the NXT bluetooth remote control J2ME applet.
 * Copyright (C) 2007-2008 Alexander Demin, <alexander@demin.ws>
 *
 * This file is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You can redistribute this file and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software Foundation;
 * either version 2 of the License, or (at your discretion) any later version.
 * See the accompanying file "COPYING.txt" for more details.
 */
import java.lang.System;
import java.lang.Runnable;
import java.lang.InterruptedException;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class NxtCanvas extends Canvas {

    String key = "?";

    NxtBrick nxtBrick;

    public NxtCanvas(NxtBrick aNxtBrick) {
       nxtBrick = aNxtBrick;
    }

    public void keyPressed(int keyCode) {
       key = "" + keyCode;

       switch( keyCode ) {
          case Canvas.KEY_NUM2: 
             key = "FORWARD";
             break;
          case Canvas.KEY_NUM4: 
             key = "LEFT   ";
             break;
          case Canvas.KEY_NUM6: 
             key = "RIGHT  ";
             break;
          case Canvas.KEY_NUM8: 
             key = "BACK   ";
             break;
          case Canvas.KEY_NUM5: 
             key = "STOP   ";
             break;
       }

       final String sentCommand = key;

       Thread sender = new Thread() {
          public void run() {
             nxtBrick.send( 1, sentCommand );
          }
       };

       sender.start();

       repaint();
    }

    public void paint(Graphics g) {

        g.setColor( 0 );
        g.fillRect( 0, 0, getWidth(),getHeight() );

        g.setColor( 0xffffff );

        if( key != null )
           g.drawString("Command: " + key, 0, 0, g.TOP|g.LEFT);
    }
}
