package net.embedded_projects.octopus.ui.widgets;

import net.embedded_projects.octopus.ui.Activator;

import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class OctopusWidget extends Canvas {

	private Image octoImage;
	private PaintListener paintListener = new PaintListener() {
		public void paintControl(org.eclipse.swt.events.PaintEvent e) {
			GC gc = e.gc;
			gc.drawImage(octoImage, 0, 0);
		};
	};
	
	public OctopusWidget(Composite parent, int style) {
		super(parent, style);
		octoImage = Activator.getImageDescriptor("icons/octopus.jpg").createImage();
		addPaintListener(paintListener);
		setSize(octoImage.getBounds().width, octoImage.getBounds().height);
	}

	
}
