package net.embedded_projects.octopus;

import java.io.IOException;

public interface Octopus {

	final static int RSP_OK = 0x01;
	final static int RSP_ERROR = 0x02;
	final static int RSP_UNKOWN_CMD = 0x03;
	final static int RSP_UNKOWN_PIN = 0x04;
	final static int RSP_WRONG_PIN_CONFIG = 0x05;
	final static int RSP_IMPOSSIBLE_PIN_CONFIG = 0x05;
	final static int RSP_TIMEOUT = 0x06;

	final static int CMD_LATENCY_TIMER_SET = 0x01;
	final static int CMD_LATENCY_TIMER_GET = 0x02;
	final static int CMD_GET_HW_ID = 0x03;
	final static int CMD_EXTERNAL_DEVICE = 0x06;

	final static int CMD_IO_INIT_PORT = 0x10;
	final static int CMD_IO_INIT_PIN = 0x11;
	final static int CMD_IO_PORT_DIRECTION_IN = 0x12;
	final static int CMD_IO_PORT_DIRECTION_OUT = 0x13;
	final static int CMD_IO_PORT_DIRECTION_TRI = 0x14;
	final static int CMD_IO_PIN_DIRECTION_IN = 0x15;
	final static int CMD_IO_PIN_DIRECTION_OUT = 0x16;
	final static int CMD_IO_PIN_DIRECTION_TRI = 0x17;
	final static int CMD_IO_PORT_SET = 0x18;
	final static int CMD_IO_PORT_GET = 0x19;
	final static int CMD_IO_PIN_SET = 0x1A;
	final static int CMD_IO_PIN_GET = 0x1B;

	final static int CMD_ADC_INIT_PIN = 0x20;
	final static int CMD_ADC_GET = 0x21;
	final static int CMD_ADC_REF = 0x22;

	final static int CMD_I2C_INIT = 0x30;
	final static int CMD_I2C_DEINIT = 0x31;
	final static int CMD_I2C_BITRATE = 0x32;
	final static int CMD_I2C_SEND_BYTES = 0x34;
	final static int CMD_I2C_RECV_BYTES = 0x35;
	final static int CMD_I2C_SEND_START = 0x36;
	final static int CMD_I2C_SEND_STOP = 0x37;

	final static int CMD_SPI_INIT = 0x40;
	final static int CMD_SPI_DEINIT = 0x41;
	final static int CMD_SPI_SPEED = 0x42;
	final static int CMD_SPI_SEND = 0x43;
	final static int CMD_SPI_RECV = 0x44;
	final static int CMD_SPI_SEND_AND_RECV = 0x45;

	final static int PARAM_ADC_AREF = 0x01;
	final static int PARAM_ADC_AVCC = 0x02;
	final static int PARAM_ADC_INTERNAL = 0x03

	/* microwire eeprom */;
	final static int CMD_EXTERNAL_93C46 = 0x01;

	final static int CMD_93C46_INIT = 0x01;
	final static int CMD_93C46_DEINIT = 0x02;
	final static int CMD_93C46_READ = 0x03;
	final static int CMD_93C46_WRITE = 0x04;
	
	public interface GPIO {
		//					0		1		2		3		4		5
		public enum Port { PORT_A, PORT_B, PORT_D, PORT_C, PORT_F, PORT_E }
		
		public void initPort(Port port) throws IOException;
		
		public void initPin(int pin) throws IOException;
		
		public void setPortDirectionOut(Port port, byte mask) throws IOException;

		public void setPortDirectionIn(Port port, byte mask) throws IOException;

		public void setPortDirectionTri(Port port, byte mask) throws IOException;

		public void setPinDirectionOut(int pin) throws IOException;

		public void setPinDirectionIn(int pin) throws IOException;

		public void setPinDirectionTri(int pin) throws IOException;

		public byte getPort(Port port) throws IOException;
		
		public void setPort(Port port, byte value) throws IOException;

		public boolean getPin(int pin) throws IOException;
		
		public void setPin(int pin, boolean value) throws IOException;

	}
	
	public interface ADC {
		
		public void init(int pin) throws IOException;
		
		public int get(int pin) throws IOException;
		
		public int ref(int ref) throws IOException;
		
	}
	
	public interface I2C {

		public int setBitrate(int speed) throws IOException;

		public void sendStart() throws IOException;

		public void sendStop() throws IOException;

		public int sendBytes(byte[] buf, int timeout) throws Exception;

		public byte[] receiveBytes(int address, int len, int timeout)
				throws Exception;
		
		public void dispose();
		
	}
	
	public void open() throws IOException;

	public void close() throws IOException;

	public boolean isOpen();
	
	public void reset();
	
	public void getHWDescription() throws IOException;

	public GPIO getGPIO();
	
	public ADC getADC();

	public I2C getI2C();

}
