/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.communication.common;

import com.ohell.data.Card;
import java.io.Serializable;

/**
 * This is object sent from client to server and reverse , in which are included player that made the last
 * game move and the card he or she played. It is immutable for obvious reasons - when a move is made it can not be changed
 * @author vasko
 */
public class PlayedMoveObject implements Serializable{

    private int seatIndex;
    private Card playedCard;

    public PlayedMoveObject(int seatIndex, Card playedCard) {
        this.seatIndex = seatIndex;
        this.playedCard = playedCard;
    }

    public Card getPlayedCard() {
        return playedCard;
    }

    public void setPlayedCard(Card playedCard) {
        this.playedCard = playedCard;
    }

    public int getSeatIndex() {
        return seatIndex;
    }
}
