/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.communication.servertoclient;

import com.ohell.data.Announce;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This object is sent from the server to the game clients in order to start the game process
 * It holds all game Announces that client applications should use in the game process.
 * The labels of the Announces should be configurable from server admin module.
 * @author vasko
 */
public class GameStartingObject implements Serializable {
    private Map<Integer,Long> seatIndexMap = new HashMap<Integer, Long>();
    private List<Announce> announces = new ArrayList<Announce>();

    public Map<Integer, Long> getSeatIndexMap() {
        return seatIndexMap;
    }    

    public List<Announce> getAnnounces() {
        return announces;
    }

    public void setAnnounces(List<Announce> announces) {
        this.announces = announces;
    }
}
