/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.communication.servertoclient;

import com.ohell.data.Card;
import java.io.Serializable;
import java.util.List;

/**
 * This class contains initializing parameters that are sent from server to client in the beginning of each Round
 * That is - player's cards and current trump
 *
 * Super class should be extracted and different implementations should be added for specific games
 * like TexasHold'em where thete is no Trump and there are community cards
 *
 * @author vasko
 */
public class InitNextRoundObject implements Serializable{

    private int roundNumber;    
    private List<Card> cards;
    private Card trump;

    public InitNextRoundObject(int roundNumber, List<Card> cards, Card trump) {
        this.roundNumber = roundNumber;        
        this.cards = cards;
        this.trump = trump;
    }

    public List<Card> getCards() {
        return cards;
    }

    public int getRoundNumber() {
        return roundNumber;
    }

    public Card getTrump() {
        return trump;
    }
}
