/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.data;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import static javax.persistence.GenerationType.IDENTITY;
/**
 *
 * @author User
 */
@Entity
public class Announce implements Serializable {
    private Long id;

    //TODO : extract enum class with different game types and map it in DB
    private String gameType;
    private int code;
    private String name;

    public Announce() {
        //this is done so that code can be zeroBased - when searching in DB  int 0 = Integer null.
        this.code = -1;
    }

    public Announce(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public void setId(Long val) {
        this.id = val;
    }

    @Id @GeneratedValue(strategy=IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Long getId() {
        return this.id;
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getName() {
        return this.name;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getGameType() {
        return gameType;
    }

    public void setGameType(String gameType) {
        this.gameType = gameType;
    }

    public String toString(){
        StringBuilder b = new StringBuilder();
        b.append("(id=");
        b.append(this.id);
        b.append("/gameType=");
        b.append(this.gameType);
        b.append("/code=");
        b.append(this.code);
        b.append("/name=");
        b.append(this.name);
        b.append(")");

        return b.toString();
    }
}
