/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.data;

import java.util.List;

/**
 *
 * @author vasko
 */
public interface CardGame {

    /**
     *
     * @return true if the game is over , false otherwise
     */
    public boolean isGameOver();

    /**
     * Updates the game score after the finish of the last round played
     * @param r - the round after which the game is to be updated
     */
    public void updateGameScore(Round r);

    /**
     * Updates the game state with
     * @param p
     * @param c
     */
    public void makeMove(Player p , Card c);

    /**     
     * @return the required players count for the current game - for example it will be 2 for Sentase and 4 for Ohell
     */
    public int requiredPlayersCount();

    
    public void makeAnnounce(Player p, Announce a);

    public void initNextRound();
}
