/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.data;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import static javax.persistence.GenerationType.IDENTITY;

/**
 * Object that holds information of which player played what card
 * @author vasko
 */
@Entity
public class PlayerCardPair implements Serializable{

    private int seatIndex;
    private Card playedCard;

    private Long id;

    @Id @GeneratedValue(strategy=IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Card getPlayedCard() {
        return playedCard;
    }

    public void setPlayedCard(Card playedCard) {
        this.playedCard = playedCard;
    }

    public int getSeatIndex() {
        return seatIndex;
    }

    public void setSeatIndex(int seatIndex) {
        this.seatIndex = seatIndex;
    }

    public PlayerCardPair() {
    }

    public PlayerCardPair(int seatIndex, Card playedCard) {
        this.seatIndex = seatIndex;
        this.playedCard = playedCard;
    }
}
