package com.ohell.data;



import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import static javax.persistence.GenerationType.IDENTITY;

@Entity
public class PlayerInRound implements Serializable{

    
    private List<Card> cards;
    
    private List<Hand> takenHands;

    private List<Announce> announces;
  
    private Player player;

    private Long id;

    public PlayerInRound () {
        cards = new ArrayList<Card>();
        takenHands = new ArrayList<Hand>();
        announces = new ArrayList<Announce>();
    }

    public void addCard(Card card) {
        cards.add(card);
    }

    @OneToMany(cascade=CascadeType.ALL, fetch=FetchType.LAZY)
    public List<Card> getCards () {
        return cards;
    }

    public void setCards (List<Card> val) {
        this.cards = val;
    }

    @OneToMany(cascade=CascadeType.ALL, fetch=FetchType.LAZY)
    public List<Announce> getHandsAnnounced () {
        return announces;
    }

    public void setHandsAnnounced (List<Announce> val) {
        this.announces = val;
    }

    public Announce getAnnounce(int index){
        if(announces.size() < index){
            return announces.get(index);
        }else{
            return null;
        }
    }

    @Transient
    public Announce getFirstAnnounce(){
        return getAnnounce(0);
    }

    public void makeAnnounce(Announce a){
        announces.add(a);
    }

    @OneToOne
    public Player getPlayer () {
        return player;
    }

    public void setPlayer (Player val) {
        this.player = val;
    }

    @OneToMany(cascade=CascadeType.ALL, fetch=FetchType.LAZY)
    public List<Hand> getTakenHands () {
        return takenHands;
    }

    public void setTakenHands (List<Hand> val) {
        this.takenHands = val;
    }

    @Id @GeneratedValue(strategy=IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

