package com.ohell.data;



import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import static javax.persistence.GenerationType.IDENTITY;
import javax.persistence.OneToOne;

@Entity
public class ScoreTable implements Serializable{

    private Long id;

    private List<PlayerGameScore> playerGameScore;
    private OhellGame ohellGame;

    public ScoreTable () {
    }

    public ScoreTable(List<PlayerGameScore> playerGameScore, OhellGame ohellGame) {
        this.playerGameScore = playerGameScore;
        this.ohellGame = ohellGame;
    }



    @OneToMany(cascade=CascadeType.ALL, fetch=FetchType.EAGER)
    public List<PlayerGameScore> getPlayerGameScore() {
        return playerGameScore;
    }

    public void setPlayerGameScore(List<PlayerGameScore> playerGameScore) {
        this.playerGameScore = playerGameScore;
    }



    @Id @GeneratedValue(strategy=IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @OneToOne(mappedBy = "score")
    public OhellGame getOhellGame() {
        return ohellGame;
    }

    public void setOhellGame(OhellGame ohellGame) {
        this.ohellGame = ohellGame;
    }

    public PlayerGameScore getChosenPlayerGameScore(Player p){
        for (PlayerGameScore pgs : playerGameScore) {
            if(pgs.getPlayer().getId().longValue() == p.getId().longValue()){
                return pgs;
            }
        }
        return null;
    }
}

